/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.FunctionLike;

@Rule(key="S138")
public class FunctionTooBigCheck
extends Check {
    private static final int DEFAULT_MAXIMUM = 120;
    @RuleProperty(key="max", description="Maximum authorized lines of code in a function", defaultValue="120")
    public int max = 120;

    public FunctionTooBigCheck() {
        super(UastNode.Kind.FUNCTION);
    }

    @Override
    public void visitNode(UastNode node) {
        FunctionLike from = FunctionLike.from(node);
        int size = node.lastToken().line - node.firstToken().line;
        if (size > this.max) {
            this.reportIssue(from.name(), String.format("This function has %s lines of code, which is greater than the %s authorized. Split it into smaller functions.", size, this.max));
        }
    }
}

