/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S134")
public class NestedControlFlowCheck
extends Check {
    private static final int DEFAULT_MAX = 4;
    @RuleProperty(description="Maximum allowed control flow statement nesting depth.", defaultValue="4")
    public int max = 4;
    private Deque<UastNode> nesting = new ArrayDeque<UastNode>();

    public NestedControlFlowCheck() {
        super(UastNode.Kind.CONDITIONAL_JUMP);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        this.nesting.clear();
    }

    @Override
    public void visitNode(UastNode node) {
        this.checkNesting(node);
        this.nesting.push(node);
    }

    @Override
    public void leaveNode(UastNode node) {
        this.nesting.pop();
    }

    private void checkNesting(UastNode node) {
        if (this.nesting.size() == this.max) {
            Issue.Message[] secondary = (Issue.Message[])this.nesting.stream().map(n -> new Issue.Message(n.getChild(UastNode.Kind.KEYWORD).orElse(node), "Nesting +1")).toArray(Issue.Message[]::new);
            this.reportIssue(node.getChild(UastNode.Kind.KEYWORD).orElse(node), "Refactor this code to not nest more than " + this.max + " control flow statements.", secondary);
        }
    }
}

