/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.EngineContext;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.AssignmentLike;
import org.sonar.uast.helpers.LiteralLike;

@Rule(key="S2068")
public class NoHardcodedCredentialsCheck
extends Check {
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd";
    private static final String MESSAGE = "'%s' detected in identifier; remove this potentially hardcoded credential.";
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd")
    public String credentialWords = "password,passwd,pwd";
    private Pattern targetPattern;
    private Pattern valuePattern;

    public NoHardcodedCredentialsCheck() {
        super(UastNode.Kind.ASSIGNMENT);
    }

    @Override
    public void initialize(EngineContext context) {
        super.initialize(context);
        String[] words = this.credentialWords.split(",");
        String pattern = Arrays.stream(words).map(Pattern::quote).collect(Collectors.joining("|"));
        this.targetPattern = Pattern.compile(pattern, 2);
        pattern = Arrays.stream(words).map(Pattern::quote).map(w -> w + "=[^\\s\"]").collect(Collectors.joining("|"));
        this.valuePattern = Pattern.compile(pattern, 2);
    }

    @Override
    public void visitNode(UastNode node) {
        LiteralLike assignmentValue;
        AssignmentLike assignment = AssignmentLike.from(node);
        if (assignment != null && (assignmentValue = LiteralLike.from(assignment.value())) != null && assignmentValue.node().is(UastNode.Kind.STRING_LITERAL) && !NoHardcodedCredentialsCheck.removeQuotes(assignmentValue.value()).isEmpty()) {
            this.testPattern(assignment.target(), this.targetPattern);
            this.testPattern(assignment.value(), this.valuePattern);
        }
    }

    private static String removeQuotes(String string) {
        if (string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void testPattern(UastNode node, Pattern pattern) {
        String nodeValue = node.joinTokens();
        Matcher matcher = pattern.matcher(nodeValue);
        if (matcher.find()) {
            this.reportIssue(node, String.format(MESSAGE, matcher.group(0)));
        }
    }
}

