/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.SyntacticEquivalence;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.CaseLike;
import org.sonar.uast.helpers.IfLike;
import org.sonar.uast.helpers.SwitchLike;

@Rule(key="S1871")
public class TwoBranchesAreIdenticalCheck
extends Check {
    private static final String MESSAGE = "This %s's code block is the same as the block for the %s on line %s.";
    private Set<UastNode> visitedIfs = new HashSet<UastNode>();

    public TwoBranchesAreIdenticalCheck() {
        super(UastNode.Kind.IF, UastNode.Kind.SWITCH);
    }

    @Override
    public void enterFile(InputFile inputFile) {
        this.visitedIfs.clear();
    }

    @Override
    public void visitNode(UastNode node) {
        this.handleIf(node);
        this.handleSwitch(node);
    }

    private void handleSwitch(UastNode node) {
        SwitchLike switchLike = SwitchLike.from(node);
        if (switchLike == null) {
            return;
        }
        List<UastNode> caseNodes = switchLike.caseNodes();
        List caseBodies = caseNodes.stream().map(CaseLike::from).filter(Objects::nonNull).map(CaseLike::body).collect(Collectors.toList());
        block0: for (int i = 1; i < caseBodies.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                UastNode duplicating = (UastNode)caseBodies.get(i);
                UastNode duplicated = (UastNode)caseBodies.get(j);
                if (duplicated == null || !SyntacticEquivalence.areEquivalent(duplicating, duplicated) || !TwoBranchesAreIdenticalCheck.isBigEnough(duplicated)) continue;
                this.reportIssue(caseNodes.get(i), caseNodes.get(j), "case");
                continue block0;
            }
        }
    }

    private void handleIf(UastNode node) {
        IfLike topIfStatement = IfLike.from(node);
        if (topIfStatement == null || this.visitedIfs.contains(node)) {
            return;
        }
        List<UastNode> ifBlocks = this.getIfBranches(topIfStatement);
        block0: for (int i = 1; i < ifBlocks.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                UastNode duplicated;
                UastNode duplicating = ifBlocks.get(i);
                if (!SyntacticEquivalence.areEquivalent(duplicating, duplicated = ifBlocks.get(j)) || !TwoBranchesAreIdenticalCheck.isBigEnoughBlock(duplicated)) continue;
                this.reportIssue(duplicating, duplicated, "branch");
                continue block0;
            }
        }
    }

    private List<UastNode> getIfBranches(IfLike topIfStatement) {
        IfLike.ElseLike elseLike = topIfStatement.elseLike();
        ArrayList<UastNode> ifBlocks = new ArrayList<UastNode>();
        ifBlocks.add(topIfStatement.thenNode());
        for (IfLike elseIf = topIfStatement.elseIf(); elseIf != null; elseIf = elseIf.elseIf()) {
            this.visitedIfs.add(elseIf.node());
            ifBlocks.add(elseIf.thenNode());
            elseLike = elseIf.elseLike();
        }
        if (elseLike != null) {
            ifBlocks.add(elseLike.elseNode());
        }
        return ifBlocks;
    }

    private static boolean isBigEnough(UastNode node) {
        UastNode.Token firstToken = node.firstToken();
        UastNode.Token lastToken = node.lastToken();
        return firstToken != null && lastToken != null && lastToken.line - firstToken.line > 0;
    }

    private static boolean isBigEnoughBlock(UastNode node) {
        List<UastNode> statements = node.getChildren(UastNode.Kind.STATEMENT);
        if (statements.isEmpty()) {
            return false;
        }
        UastNode.Token firstToken = statements.get(0).firstToken();
        UastNode.Token lastToken = statements.get(statements.size() - 1).lastToken();
        return firstToken != null && lastToken != null && lastToken.line - firstToken.line > 0;
    }

    private void reportIssue(UastNode duplicating, UastNode duplicated, String caseOrBranch) {
        UastNode.Token firstToken = duplicated.firstToken();
        if (firstToken != null) {
            int duplicatedBranchFirstLine = firstToken.line;
            this.reportIssue(duplicating, String.format(MESSAGE, caseOrBranch, caseOrBranch, duplicatedBranchFirstLine), new Issue.Message(duplicated, "Original"));
        }
    }
}

