/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.uast.UastNode;

public class BinaryExpressionLike {
    private final UastNode node;
    private final UastNode leftOperand;
    private final UastNode operator;
    private final UastNode rightOperand;

    public BinaryExpressionLike(UastNode node, UastNode leftOperand, UastNode operator, UastNode rightOperand) {
        this.node = node;
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @CheckForNull
    public static BinaryExpressionLike from(UastNode node) {
        Optional<UastNode> leftOperand = node.getChild(UastNode.Kind.LEFT_OPERAND);
        Optional<UastNode> operator = node.getChild(UastNode.Kind.OPERATOR);
        Optional<UastNode> rightOperand = node.getChild(UastNode.Kind.RIGHT_OPERAND);
        if (leftOperand.isPresent() && operator.isPresent() && rightOperand.isPresent()) {
            return new BinaryExpressionLike(node, leftOperand.get(), operator.get(), rightOperand.get());
        }
        return null;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode leftOperand() {
        return this.leftOperand;
    }

    public UastNode operator() {
        return this.operator;
    }

    public UastNode rightOperand() {
        return this.rightOperand;
    }
}

