/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.Version;
import org.sonar.db.dialect.AbstractDialect;

public class MySql
extends AbstractDialect {
    public static final String ID = "mysql";
    private static final Version MIN_SUPPORTED_VERSION = Version.create((int)5, (int)6, (int)0);

    public MySql() {
        super(ID, "com.mysql.jdbc.Driver", "true", "false", "SELECT 1");
    }

    @Override
    public boolean matchesJdbcUrl(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:mysql:");
    }

    @Override
    public int getScrollDefaultFetchSize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getScrollSingleRowFetchSize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean supportsMigration() {
        return true;
    }

    @Override
    public String getSqlFromDual() {
        return "from dual";
    }

    @Override
    public void init(DatabaseMetaData metaData) throws SQLException {
        this.checkDbVersion(metaData, MIN_SUPPORTED_VERSION);
    }
}

