/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.PackedMemoryCloneIndex;

public class MemoryCloneIndex
implements CloneIndex {
    private Map<String, List<Block>> byResource = new LinkedHashMap<String, List<Block>>();
    private Map<ByteArray, List<Block>> byHash = new LinkedHashMap<ByteArray, List<Block>>();

    @Override
    public Collection<Block> getByResourceId(String resourceId) {
        return this.byResource.computeIfAbsent(resourceId, k -> new ArrayList());
    }

    @Override
    public Collection<Block> getBySequenceHash(ByteArray sequenceHash) {
        return this.byHash.computeIfAbsent(sequenceHash, k -> new ArrayList());
    }

    @Override
    public void insert(Block block) {
        this.getByResourceId(block.getResourceId()).add(block);
        this.getBySequenceHash(block.getBlockHash()).add(block);
    }

    @Override
    public Iterator<PackedMemoryCloneIndex.ResourceBlocks> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int noResources() {
        return this.byResource.keySet().size();
    }
}

