/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Rule(key="S125")
public class CommentedOutCodeCheck
extends SimpleXPathBasedCheck {
    public static final String RULE_KEY = "S125";
    private final XPathExpression commentsExpression = this.getXPathExpression("//comment()");
    private final Set<Node> visitedNodes = new HashSet<Node>();

    @Override
    public void scanFile(XmlFile file) {
        Charset charset = file.getInputFile().charset();
        for (Node comment : this.getComments(file)) {
            if (this.visitedNodes.contains(comment)) continue;
            List<Node> siblingComments = CommentedOutCodeCheck.getNextCommentSiblings(comment);
            this.checkCommentBlock(siblingComments, charset);
            this.visitedNodes.addAll(siblingComments);
        }
        this.visitedNodes.clear();
    }

    private void checkCommentBlock(List<Node> comments, Charset charset) {
        int numberComments = comments.size();
        for (int i = 0; i < numberComments; ++i) {
            List<Node> commentsGroup = comments.subList(i, numberComments);
            if (!CommentedOutCodeCheck.isParseableXml(commentsGroup, charset)) continue;
            XmlTextRange start = XmlFile.nodeLocation(commentsGroup.get(0));
            XmlTextRange end = XmlFile.nodeLocation(commentsGroup.get(commentsGroup.size() - 1));
            this.reportIssue(new XmlTextRange(start, end), "Remove this commented out code.", Collections.emptyList());
            break;
        }
    }

    private List<Node> getComments(XmlFile file) {
        return this.evaluateAsList(this.commentsExpression, file.getDocument()).stream().filter(comment -> comment.getTextContent().trim().startsWith("<")).collect(Collectors.toList());
    }

    private static List<Node> getNextCommentSiblings(Node comment) {
        ArrayList<Node> results = new ArrayList<Node>();
        for (Node current = comment; current != null; current = current.getNextSibling()) {
            short nodeType = current.getNodeType();
            if (nodeType == 8) {
                results.add(current);
                continue;
            }
            if (nodeType != 3 || !CommentedOutCodeCheck.isEmpty(current)) break;
        }
        return results;
    }

    private static boolean isEmpty(Node current) {
        return current.getTextContent().trim().isEmpty();
    }

    private static boolean isParseableXml(List<Node> siblingComments, Charset charset) {
        String commentsAsSingleString = siblingComments.stream().map(Node::getTextContent).collect(Collectors.joining("\n"));
        try (ByteArrayInputStream stream = new ByteArrayInputStream(commentsAsSingleString.getBytes(charset));){
            SafetyFactory.createDocumentBuilder(false).parse(stream);
        }
        catch (IOException | SAXException e) {
            return false;
        }
        return true;
    }
}

