/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeScannerContextMapper;
import org.sonar.db.ce.LogsIteratorInputStream;

public class CeScannerContextDao
implements Dao {
    private final System2 system;

    public CeScannerContextDao(System2 system) {
        this.system = system;
    }

    public void insert(DbSession dbSession, String taskUuid, CloseableIterator<String> scannerContextLines) {
        Preconditions.checkArgument((boolean)scannerContextLines.hasNext(), (Object)"Scanner context can not be empty");
        long now = this.system.now();
        Connection connection = dbSession.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement("INSERT INTO ce_scanner_context (task_uuid, created_at, updated_at, context_data) VALUES (?, ?, ?, ?)");
             LogsIteratorInputStream inputStream = new LogsIteratorInputStream(scannerContextLines, StandardCharsets.UTF_8);){
            stmt.setString(1, taskUuid);
            stmt.setLong(2, now);
            stmt.setLong(3, now);
            stmt.setBinaryStream(4, inputStream);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (IOException | SQLException e) {
            throw new IllegalStateException("Fail to insert scanner context for task " + taskUuid, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<String> selectScannerContext(DbSession dbSession, String taskUuid) {
        try (PreparedStatement stmt = dbSession.getConnection().prepareStatement("select context_data from ce_scanner_context where task_uuid=?");){
            Optional<String> optional;
            block18: {
                ResultSet rs;
                block16: {
                    Optional<String> optional2;
                    block17: {
                        stmt.setString(1, taskUuid);
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            optional2 = Optional.of(IOUtils.toString((InputStream)rs.getBinaryStream(1), (Charset)StandardCharsets.UTF_8));
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (rs == null) break block18;
                rs.close();
            }
            return optional;
        }
        catch (IOException | SQLException e) {
            throw new IllegalStateException("Fail to retrieve scanner context of task " + taskUuid, e);
        }
    }

    public Set<String> selectOlderThan(DbSession dbSession, long beforeDate) {
        return CeScannerContextDao.mapper(dbSession).selectOlderThan(beforeDate);
    }

    public void deleteByUuids(DbSession dbSession, Collection<String> uuids) {
        DatabaseUtils.executeLargeUpdates(uuids, CeScannerContextDao.mapper(dbSession)::deleteByUuids);
    }

    private static CeScannerContextMapper mapper(DbSession dbSession) {
        return (CeScannerContextMapper)dbSession.getMapper(CeScannerContextMapper.class);
    }
}

