/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;
import org.sonar.db.component.ComponentDto;

public class ComponentTreeQuery {
    @CheckForNull
    private final String nameOrKeyQuery;
    @CheckForNull
    private final ArrayList<String> qualifiers;
    @CheckForNull
    private final ArrayList<String> scopes;
    private final String baseUuid;
    private final Strategy strategy;

    private ComponentTreeQuery(Builder builder) {
        this.nameOrKeyQuery = builder.nameOrKeyQuery;
        this.qualifiers = builder.qualifiers == null ? null : Lists.newArrayList((Iterable)builder.qualifiers);
        this.scopes = builder.scopes == null ? null : Lists.newArrayList((Iterable)builder.scopes);
        this.baseUuid = builder.baseUuid;
        this.strategy = Objects.requireNonNull(builder.strategy);
    }

    @CheckForNull
    public Collection<String> getQualifiers() {
        return this.qualifiers;
    }

    @CheckForNull
    public Collection<String> getScopes() {
        return this.scopes;
    }

    @CheckForNull
    public String getNameOrKeyQuery() {
        return this.nameOrKeyQuery;
    }

    @CheckForNull
    public String getNameOrKeyUpperLikeQuery() {
        return this.nameOrKeyQuery == null ? null : DaoUtils.buildLikeValue(this.nameOrKeyQuery, WildcardPosition.BEFORE_AND_AFTER).toUpperCase(Locale.ENGLISH);
    }

    public String getBaseUuid() {
        return this.baseUuid;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public String getUuidPath(ComponentDto component) {
        switch (this.strategy) {
            case CHILDREN: {
                return component.getUuidPath() + component.uuid() + ".";
            }
            case LEAVES: {
                return DaoUtils.buildLikeValue(component.getUuidPath() + component.uuid() + ".", WildcardPosition.AFTER);
            }
        }
        throw new IllegalArgumentException("Unknown strategy : " + (Object)((Object)this.strategy));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @CheckForNull
        private String nameOrKeyQuery;
        @CheckForNull
        private Collection<String> qualifiers;
        @CheckForNull
        private Collection<String> scopes;
        private String baseUuid;
        private Strategy strategy;

        private Builder() {
        }

        public ComponentTreeQuery build() {
            Objects.requireNonNull(this.baseUuid);
            return new ComponentTreeQuery(this);
        }

        public Builder setNameOrKeyQuery(@Nullable String nameOrKeyQuery) {
            this.nameOrKeyQuery = nameOrKeyQuery;
            return this;
        }

        public Builder setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setBaseUuid(String uuid) {
            this.baseUuid = uuid;
            return this;
        }

        public Builder setStrategy(Strategy strategy) {
            this.strategy = Objects.requireNonNull(strategy);
            return this;
        }
    }

    public static enum Strategy {
        CHILDREN,
        LEAVES;

    }
}

