/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.event;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;

public class EventComponentChangeDto {
    private String uuid;
    private String eventUuid;
    private ChangeCategory category;
    private String componentUuid;
    private String componentKey;
    private String componentName;
    @Nullable
    private String componentBranchKey;
    private long createdAt;

    public String getUuid() {
        return this.uuid;
    }

    public EventComponentChangeDto setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getEventUuid() {
        return this.eventUuid;
    }

    public EventComponentChangeDto setEventUuid(String eventUuid) {
        this.eventUuid = eventUuid;
        return this;
    }

    public ChangeCategory getCategory() {
        return this.category;
    }

    public EventComponentChangeDto setCategory(ChangeCategory category) {
        this.category = category;
        return this;
    }

    private String getChangeCategory() {
        return this.category == null ? null : this.category.dbValue;
    }

    private EventComponentChangeDto setChangeCategory(String changeCategory) {
        this.category = ChangeCategory.fromDbValue(changeCategory).orElseThrow(() -> new IllegalArgumentException("Unsupported changeCategory DB value: " + changeCategory));
        return this;
    }

    public String getComponentUuid() {
        return this.componentUuid;
    }

    public EventComponentChangeDto setComponentUuid(String componentUuid) {
        this.componentUuid = componentUuid;
        return this;
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    public EventComponentChangeDto setComponentKey(String componentKey) {
        this.componentKey = componentKey;
        return this;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public EventComponentChangeDto setComponentName(String componentName) {
        this.componentName = componentName;
        return this;
    }

    @Nullable
    public String getComponentBranchKey() {
        return this.componentBranchKey;
    }

    public EventComponentChangeDto setComponentBranchKey(@Nullable String componentBranchKey) {
        this.componentBranchKey = componentBranchKey;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    private void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public static enum ChangeCategory {
        FAILED_QUALITY_GATE("FAILED_QG"),
        ADDED("ADDED"),
        REMOVED("REMOVED");

        private final String dbValue;

        private ChangeCategory(String dbValue) {
            this.dbValue = dbValue;
        }

        public static Optional<ChangeCategory> fromDbValue(String dbValue) {
            return Arrays.stream(ChangeCategory.values()).filter(t -> t.dbValue.equals(dbValue)).findAny();
        }
    }
}

