/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.issue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueChangeMapper;

public class IssueChangeDao
implements Dao {
    public List<FieldDiffs> selectChangelogByIssue(DbSession session, String issueKey) {
        return (List)this.selectByTypeAndIssueKeys(session, Collections.singletonList(issueKey), "diff").stream().map(IssueChangeDto::toFieldDiffs).collect(MoreCollectors.toList());
    }

    public List<IssueChangeDto> selectByTypeAndIssueKeys(DbSession session, Collection<String> issueKeys, String changeType) {
        return DatabaseUtils.executeLargeInputs(issueKeys, issueKeys1 -> IssueChangeDao.mapper(session).selectByIssuesAndType((List<String>)issueKeys1, changeType));
    }

    public List<IssueChangeDto> selectByIssueKeys(DbSession session, Collection<String> issueKeys) {
        return DatabaseUtils.executeLargeInputs(issueKeys, issueKeys1 -> IssueChangeDao.mapper(session).selectByIssues((List<String>)issueKeys1));
    }

    public Optional<IssueChangeDto> selectCommentByKey(DbSession session, String commentKey) {
        return Optional.ofNullable(IssueChangeDao.mapper(session).selectByKeyAndType(commentKey, "comment"));
    }

    public void scrollDiffChangesOfIssues(DbSession dbSession, Collection<String> issueKeys, ResultHandler<IssueChangeDto> handler) {
        if (issueKeys.isEmpty()) {
            return;
        }
        DatabaseUtils.executeLargeInputsWithoutOutput(issueKeys, issueKeySubList -> IssueChangeDao.mapper(dbSession).scrollDiffChangesOfIssues((List<String>)issueKeySubList, handler));
    }

    public void insert(DbSession session, IssueChangeDto change) {
        IssueChangeDao.mapper(session).insert(change);
    }

    public boolean delete(DbSession session, String key) {
        IssueChangeMapper mapper = IssueChangeDao.mapper(session);
        int count = mapper.delete(key);
        session.commit();
        return count == 1;
    }

    public boolean update(DbSession dbSession, IssueChangeDto change) {
        int count = IssueChangeDao.mapper(dbSession).update(change);
        return count == 1;
    }

    private static IssueChangeMapper mapper(DbSession session) {
        return (IssueChangeMapper)session.getMapper(IssueChangeMapper.class);
    }
}

