/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceAlterAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceClearCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceContainsCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetAndAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceIsNullCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceSetAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicReferenceSetCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.util.Preconditions;

public class ClientAtomicReferenceProxy<E>
extends PartitionSpecificClientProxy
implements IAtomicReference<E> {
    private static final ClientMessageDecoder APPLY_DECODER = new ClientMessageDecoder(){

        public <R> R decodeClientMessage(ClientMessage clientMessage) {
            return (R)AtomicReferenceApplyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder ALTER_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder ALTER_AND_GET_DECODER = new ClientMessageDecoder(){

        public <E> E decodeClientMessage(ClientMessage clientMessage) {
            return (E)AtomicReferenceAlterAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_ALTER_DECODER = new ClientMessageDecoder(){

        public <E> E decodeClientMessage(ClientMessage clientMessage) {
            return (E)AtomicReferenceGetAndAlterCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder COMPARE_AND_SET_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return AtomicReferenceCompareAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder CONTAINS_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return AtomicReferenceContainsCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_DECODER = new ClientMessageDecoder(){

        public <E> E decodeClientMessage(ClientMessage clientMessage) {
            return (E)AtomicReferenceGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SET_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder CLEAR_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder GET_AND_SET_DECODER = new ClientMessageDecoder(){

        public <E> E decodeClientMessage(ClientMessage clientMessage) {
            return (E)AtomicReferenceGetAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder IS_NULL_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return AtomicReferenceIsNullCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    public ClientAtomicReferenceProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<E, R> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceApplyCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        return this.invokeOnPartitionAsync(request, APPLY_DECODER);
    }

    public <R> R apply(IFunction<E, R> function) {
        return (R)this.applyAsync(function).join();
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceAlterCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        return this.invokeOnPartitionAsync(request, ALTER_DECODER);
    }

    public void alter(IFunction<E, E> function) {
        this.alterAsync(function).join();
    }

    public InternalCompletableFuture<E> alterAndGetAsync(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceAlterAndGetCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        return this.invokeOnPartitionAsync(request, ALTER_AND_GET_DECODER);
    }

    public E alterAndGet(IFunction<E, E> function) {
        return (E)this.alterAndGetAsync(function).join();
    }

    public InternalCompletableFuture<E> getAndAlterAsync(IFunction<E, E> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicReferenceGetAndAlterCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        return this.invokeOnPartitionAsync(request, GET_AND_ALTER_DECODER);
    }

    public E getAndAlter(IFunction<E, E> function) {
        return (E)this.getAndAlterAsync(function).join();
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(E expect, E update) {
        ClientMessage request = AtomicReferenceCompareAndSetCodec.encodeRequest((String)this.name, (Data)this.toData(expect), (Data)this.toData(update));
        return this.invokeOnPartitionAsync(request, COMPARE_AND_SET_DECODER);
    }

    public boolean compareAndSet(E expect, E update) {
        return (Boolean)this.compareAndSetAsync(expect, update).join();
    }

    public InternalCompletableFuture<Boolean> containsAsync(E expected) {
        ClientMessage request = AtomicReferenceContainsCodec.encodeRequest((String)this.name, (Data)this.toData(expected));
        return this.invokeOnPartitionAsync(request, CONTAINS_DECODER);
    }

    public boolean contains(E expected) {
        return (Boolean)this.containsAsync(expected).join();
    }

    public InternalCompletableFuture<E> getAsync() {
        ClientMessage request = AtomicReferenceGetCodec.encodeRequest((String)this.name);
        return this.invokeOnPartitionAsync(request, GET_DECODER);
    }

    public E get() {
        return (E)this.getAsync().join();
    }

    public InternalCompletableFuture<Void> setAsync(E newValue) {
        ClientMessage request = AtomicReferenceSetCodec.encodeRequest((String)this.name, (Data)this.toData(newValue));
        return this.invokeOnPartitionAsync(request, SET_DECODER);
    }

    public void set(E newValue) {
        this.setAsync(newValue).join();
    }

    public InternalCompletableFuture<Void> clearAsync() {
        ClientMessage request = AtomicReferenceClearCodec.encodeRequest((String)this.name);
        return this.invokeOnPartitionAsync(request, CLEAR_DECODER);
    }

    public void clear() {
        this.clearAsync().join();
    }

    public InternalCompletableFuture<E> getAndSetAsync(E newValue) {
        ClientMessage request = AtomicReferenceGetAndSetCodec.encodeRequest((String)this.name, (Data)this.toData(newValue));
        return this.invokeOnPartitionAsync(request, GET_AND_SET_DECODER);
    }

    public E getAndSet(E newValue) {
        return (E)this.getAndSetAsync(newValue).join();
    }

    public E setAndGet(E update) {
        ClientMessage request = AtomicReferenceSetAndGetCodec.encodeRequest((String)this.name, (Data)this.toData(update));
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(AtomicReferenceSetAndGetCodec.decodeResponse((ClientMessage)response).response);
    }

    public InternalCompletableFuture<Boolean> isNullAsync() {
        ClientMessage request = AtomicReferenceIsNullCodec.encodeRequest((String)this.name);
        return this.invokeOnPartitionAsync(request, IS_NULL_DECODER);
    }

    public boolean isNull() {
        return (Boolean)this.isNullAsync().join();
    }

    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

