/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.FlakeIdGeneratorNewIdBatchCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.flakeidgen.impl.AutoBatcher;
import com.hazelcast.flakeidgen.impl.IdBatch;
import java.util.concurrent.TimeUnit;

public class ClientFlakeIdGeneratorProxy
extends ClientProxy
implements FlakeIdGenerator {
    private final AutoBatcher batcher;

    public ClientFlakeIdGeneratorProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
        ClientFlakeIdGeneratorConfig config = this.getContext().getClientConfig().findFlakeIdGeneratorConfig(this.getName());
        this.batcher = new AutoBatcher(config.getPrefetchCount(), config.getPrefetchValidityMillis(), new AutoBatcher.IdBatchSupplier(){

            public IdBatch newIdBatch(int batchSize) {
                return ClientFlakeIdGeneratorProxy.this.newIdBatch(batchSize);
            }
        });
    }

    public long newId() {
        return this.batcher.newId();
    }

    private IdBatch newIdBatch(int batchSize) {
        ClientMessage requestMsg = FlakeIdGeneratorNewIdBatchCodec.encodeRequest((String)this.name, (int)batchSize);
        ClientMessage responseMsg = (ClientMessage)new ClientInvocation(this.getClient(), requestMsg, this.getName()).invoke().join();
        FlakeIdGeneratorNewIdBatchCodec.ResponseParameters response = FlakeIdGeneratorNewIdBatchCodec.decodeResponse((ClientMessage)responseMsg);
        return new IdBatch(response.base, response.increment, response.batchSize);
    }

    public boolean init(long id) {
        long reserve = TimeUnit.HOURS.toMillis(1L) << 22;
        return this.newId() >= id + reserve;
    }

    public String toString() {
        return "FlakeIdGenerator{name='" + this.name + "'}";
    }
}

