/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="MouseEventWithoutKeyboardEquivalentCheck")
public class MouseEventWithoutKeyboardEquivalentCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (node.getLocalName().equals(node.getNodeName())) {
            String attribute = null;
            if (MouseEventWithoutKeyboardEquivalentCheck.hasOnClick(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasOnKeyPress(node)) {
                attribute = "onKeyPress";
            } else if (MouseEventWithoutKeyboardEquivalentCheck.hasOnMouseover(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasOnFocus(node)) {
                attribute = "onFocus";
            } else if (MouseEventWithoutKeyboardEquivalentCheck.hasOnMouseout(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasOnBlur(node)) {
                attribute = "onBlur";
            }
            if (attribute != null) {
                this.createViolation(node.getStartLinePosition(), "Add a '" + attribute + "' attribute to this <" + node.getNodeName() + "> tag.");
            }
        }
    }

    private static boolean hasOnClick(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "CLICK");
    }

    private static boolean hasOnKeyPress(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "KEYPRESS");
    }

    private static boolean hasOnMouseover(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "MOUSEOVER");
    }

    private static boolean hasOnFocus(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "FOCUS");
    }

    private static boolean hasOnMouseout(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ONMOUSEOUT") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "(MOUSEOUT)") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ON-MOUSEOUT") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "NG-MOUSELEAVE");
    }

    private static boolean hasOnBlur(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "BLUR");
    }

    private static boolean hasEventHandlerAttribute(TagNode node, String eventName) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ON" + eventName) || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "(" + eventName + ")") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ON-" + eventName) || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "NG-" + eventName);
    }

    private static boolean hasAttribute(TagNode node, String attributeName) {
        return node.getAttribute(attributeName) != null;
    }
}

