/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="TableWithoutCaptionCheck")
public class TableWithoutCaptionCheck
extends AbstractPageCheck {
    private int tableLine = 0;
    private boolean foundCaption;

    @Override
    public void startElement(TagNode node) {
        if (TableWithoutCaptionCheck.isTable(node)) {
            this.foundCaption = false;
            this.tableLine = node.getStartLinePosition();
        } else if (TableWithoutCaptionCheck.isCaption(node)) {
            this.foundCaption = true;
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (TableWithoutCaptionCheck.isTable(node)) {
            if (!this.foundCaption && this.tableLine != 0) {
                this.createViolation(this.tableLine, "Add a <caption> tag to this table.");
            }
            this.foundCaption = false;
            this.tableLine = 0;
        }
    }

    private static boolean isTable(TagNode node) {
        return "TABLE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isCaption(TagNode node) {
        return "CAPTION".equalsIgnoreCase(node.getNodeName());
    }
}

