/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.authentication.AuthenticationRedirection;
import org.sonar.server.authentication.Cookies;
import org.sonar.server.authentication.event.AuthenticationException;

public final class AuthenticationError {
    private static final String UNAUTHORIZED_PATH = "/sessions/unauthorized";
    private static final Logger LOGGER = Loggers.get(AuthenticationError.class);
    private static final String AUTHENTICATION_ERROR_COOKIE = "AUTHENTICATION-ERROR";
    private static final int FIVE_MINUTES_IN_SECONDS = 300;

    private AuthenticationError() {
    }

    static void handleError(Exception e, HttpServletRequest request, HttpServletResponse response, String message) {
        LOGGER.warn(message, (Throwable)e);
        AuthenticationError.redirectToUnauthorized(request, response);
    }

    static void handleError(HttpServletRequest request, HttpServletResponse response, String message) {
        LOGGER.warn(message);
        AuthenticationError.redirectToUnauthorized(request, response);
    }

    static void handleAuthenticationError(AuthenticationException e, HttpServletRequest request, HttpServletResponse response) {
        String publicMessage = e.getPublicMessage();
        if (publicMessage != null && !publicMessage.isEmpty()) {
            AuthenticationError.addErrorCookie(request, response, publicMessage);
        }
        AuthenticationError.redirectToUnauthorized(request, response);
    }

    public static void addErrorCookie(HttpServletRequest request, HttpServletResponse response, String value) {
        response.addCookie(Cookies.newCookieBuilder(request).setName(AUTHENTICATION_ERROR_COOKIE).setValue(AuthenticationRedirection.encodeMessage(value)).setHttpOnly(false).setExpiry(300).build());
    }

    private static void redirectToUnauthorized(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationRedirection.redirectTo(response, request.getContextPath() + UNAUTHORIZED_PATH);
    }
}

