/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.security.Authenticator;
import org.sonar.api.security.ExternalGroupsProvider;
import org.sonar.api.security.ExternalUsersProvider;
import org.sonar.api.security.SecurityRealm;
import org.sonar.api.security.UserDetails;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.Credentials;
import org.sonar.server.authentication.UserRegistrar;
import org.sonar.server.authentication.UserRegistration;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.user.SecurityRealmFactory;

public class CredentialsExternalAuthentication
implements Startable {
    private static final Logger LOG = Loggers.get(CredentialsExternalAuthentication.class);
    private final Configuration config;
    private final SecurityRealmFactory securityRealmFactory;
    private final UserRegistrar userRegistrar;
    private final AuthenticationEvent authenticationEvent;
    private SecurityRealm realm;
    private Authenticator authenticator;
    private ExternalUsersProvider externalUsersProvider;
    private ExternalGroupsProvider externalGroupsProvider;

    public CredentialsExternalAuthentication(Configuration config, SecurityRealmFactory securityRealmFactory, UserRegistrar userRegistrar, AuthenticationEvent authenticationEvent) {
        this.config = config;
        this.securityRealmFactory = securityRealmFactory;
        this.userRegistrar = userRegistrar;
        this.authenticationEvent = authenticationEvent;
    }

    public void start() {
        this.realm = this.securityRealmFactory.getRealm();
        if (this.realm != null) {
            this.authenticator = Objects.requireNonNull(this.realm.doGetAuthenticator(), "No authenticator available");
            this.externalUsersProvider = Objects.requireNonNull(this.realm.getUsersProvider(), "No users provider available");
            this.externalGroupsProvider = this.realm.getGroupsProvider();
        }
    }

    public Optional<UserDto> authenticate(Credentials credentials, HttpServletRequest request, AuthenticationEvent.Method method) {
        if (this.realm == null) {
            return Optional.empty();
        }
        return Optional.of(this.doAuthenticate(this.fixCase(credentials), request, method));
    }

    private UserDto doAuthenticate(Credentials credentials, HttpServletRequest request, AuthenticationEvent.Method method) {
        try {
            ExternalUsersProvider.Context externalUsersProviderContext = new ExternalUsersProvider.Context(credentials.getLogin(), request);
            UserDetails details = this.externalUsersProvider.doGetUserDetails(externalUsersProviderContext);
            if (details == null) {
                throw AuthenticationException.newBuilder().setSource(this.realmEventSource(method)).setLogin(credentials.getLogin()).setMessage("No user details").build();
            }
            Authenticator.Context authenticatorContext = new Authenticator.Context(credentials.getLogin(), (String)credentials.getPassword().orElse(null), request);
            boolean status = this.authenticator.doAuthenticate(authenticatorContext);
            if (!status) {
                throw AuthenticationException.newBuilder().setSource(this.realmEventSource(method)).setLogin(credentials.getLogin()).setMessage("Realm returned authenticate=false").build();
            }
            UserDto userDto = this.synchronize(credentials.getLogin(), details, request, method);
            this.authenticationEvent.loginSuccess(request, credentials.getLogin(), this.realmEventSource(method));
            return userDto;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error during authentication", (Throwable)e);
            throw AuthenticationException.newBuilder().setSource(this.realmEventSource(method)).setLogin(credentials.getLogin()).setMessage(e.getMessage()).build();
        }
    }

    private AuthenticationEvent.Source realmEventSource(AuthenticationEvent.Method method) {
        return AuthenticationEvent.Source.realm(method, this.realm.getName());
    }

    private UserDto synchronize(String userLogin, UserDetails details, HttpServletRequest request, AuthenticationEvent.Method method) {
        String name = details.getName();
        UserIdentity.Builder userIdentityBuilder = UserIdentity.builder().setLogin(userLogin).setName(StringUtils.isEmpty((String)name) ? userLogin : name).setEmail(StringUtils.trimToNull((String)details.getEmail())).setProviderLogin(userLogin);
        if (this.externalGroupsProvider != null) {
            ExternalGroupsProvider.Context context = new ExternalGroupsProvider.Context(userLogin, request);
            Collection groups = this.externalGroupsProvider.doGetGroups(context);
            userIdentityBuilder.setGroups(new HashSet(groups));
        }
        return this.userRegistrar.register(UserRegistration.builder().setUserIdentity(userIdentityBuilder.build()).setProvider(new ExternalIdentityProvider()).setSource(this.realmEventSource(method)).setExistingEmailStrategy(UserRegistration.ExistingEmailStrategy.FORBID).setUpdateLoginStrategy(UserRegistration.UpdateLoginStrategy.ALLOW).build());
    }

    private Credentials fixCase(Credentials credentials) {
        if (this.config.getBoolean("sonar.authenticator.downcase").orElse(false).booleanValue()) {
            return new Credentials(credentials.getLogin().toLowerCase(Locale.ENGLISH), credentials.getPassword().orElse(null));
        }
        return credentials;
    }

    public void stop() {
    }

    private static class ExternalIdentityProvider
    implements IdentityProvider {
        private ExternalIdentityProvider() {
        }

        public String getKey() {
            return "sonarqube";
        }

        public String getName() {
            return "sonarqube";
        }

        public Display getDisplay() {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean allowsUsersToSignUp() {
            return true;
        }
    }
}

