/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication.exception;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.AuthenticationError;
import org.sonar.server.authentication.exception.RedirectionException;

public class EmailAlreadyExistsRedirectionException
extends RedirectionException {
    private static final String PATH = "/sessions/email_already_exists";
    private static final String EMAIL_FIELD = "email";
    private static final String LOGIN_FIELD = "login";
    private static final String PROVIDER_FIELD = "provider";
    private static final String EXISTING_LOGIN_FIELD = "existingLogin";
    private static final String EXISTING_PROVIDER_FIELD = "existingProvider";
    private final String email;
    private final UserDto existingUser;
    private final UserIdentity userIdentity;
    private final IdentityProvider provider;

    public EmailAlreadyExistsRedirectionException(String email, UserDto existingUser, UserIdentity userIdentity, IdentityProvider provider) {
        this.email = email;
        this.existingUser = existingUser;
        this.userIdentity = userIdentity;
        this.provider = provider;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response) {
        Gson gson = new GsonBuilder().create();
        String message = gson.toJson((Object)ImmutableMap.of((Object)EMAIL_FIELD, (Object)this.email, (Object)LOGIN_FIELD, (Object)this.userIdentity.getProviderLogin(), (Object)PROVIDER_FIELD, (Object)this.provider.getKey(), (Object)EXISTING_LOGIN_FIELD, (Object)this.existingUser.getExternalLogin(), (Object)EXISTING_PROVIDER_FIELD, (Object)this.existingUser.getExternalIdentityProvider()));
        AuthenticationError.addErrorCookie(request, response, message);
    }

    @Override
    public String getPath(String contextPath) {
        return contextPath + PATH;
    }
}

