/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.FilePathWithHashDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.process.ProcessProperties;
import org.sonar.scanner.protocol.input.FileData;
import org.sonar.scanner.protocol.input.MultiModuleProjectRepository;
import org.sonar.scanner.protocol.input.ProjectRepositories;
import org.sonar.scanner.protocol.input.SingleProjectRepository;
import org.sonar.server.batch.ProjectDataQuery;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class ProjectDataLoader {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final boolean isSonarCloud;

    public ProjectDataLoader(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder, Configuration configuration) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.isSonarCloud = configuration.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
    }

    public ProjectRepositories load(ProjectDataQuery query) {
        try (DbSession session = this.dbClient.openSession(false);){
            String projectKey = query.getProjectKey();
            String branch = query.getBranch();
            String pullRequest = query.getPullRequest();
            ComponentDto project = this.componentFinder.getByKey(session, projectKey);
            WsUtils.checkRequest(project.isRootProject(), "Key '%s' belongs to a component which is not a Project", projectKey);
            boolean hasScanPerm = this.userSession.hasComponentPermission("scan", project) || this.userSession.hasPermission(OrganizationPermission.SCAN, project.getOrganizationUuid());
            this.checkPermission(hasScanPerm);
            ComponentDto branchOrMainModule = branch == null && pullRequest == null ? project : this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(session, projectKey, branch, pullRequest);
            List modulesTree = this.dbClient.componentDao().selectEnabledDescendantModules(session, branchOrMainModule.uuid());
            List<FilePathWithHashDto> files = this.searchFilesWithHashAndRevision(session, branchOrMainModule);
            if (modulesTree.size() > 1) {
                MultiModuleProjectRepository repository = new MultiModuleProjectRepository();
                ProjectDataLoader.addFileDataPerModule(repository, modulesTree, files);
                MultiModuleProjectRepository multiModuleProjectRepository = repository;
                return multiModuleProjectRepository;
            }
            SingleProjectRepository repository = new SingleProjectRepository();
            ProjectDataLoader.addFileData(repository, files);
            SingleProjectRepository singleProjectRepository = repository;
            return singleProjectRepository;
        }
    }

    private List<FilePathWithHashDto> searchFilesWithHashAndRevision(DbSession session, @Nullable ComponentDto module) {
        if (module == null) {
            return Collections.emptyList();
        }
        return module.isRootProject() ? this.dbClient.componentDao().selectEnabledFilesFromProject(session, module.uuid()) : this.dbClient.componentDao().selectEnabledDescendantFiles(session, module.uuid());
    }

    private static void addFileDataPerModule(MultiModuleProjectRepository data, List<ComponentDto> moduleChildren, List<FilePathWithHashDto> files) {
        HashMap moduleKeysByUuid = Maps.newHashMap();
        for (ComponentDto module : moduleChildren) {
            moduleKeysByUuid.put(module.uuid(), module.getKey());
        }
        for (FilePathWithHashDto file : files) {
            FileData fileData = new FileData(file.getSrcHash(), file.getRevision());
            data.addFileDataToModule((String)moduleKeysByUuid.get(file.getModuleUuid()), file.getPath(), fileData);
        }
    }

    private static void addFileData(SingleProjectRepository data, List<FilePathWithHashDto> files) {
        for (FilePathWithHashDto file : files) {
            FileData fileData = new FileData(file.getSrcHash(), file.getRevision());
            data.addFileData(file.getPath(), fileData);
        }
    }

    private void checkPermission(boolean hasScanPerm) {
        if (!hasScanPerm) {
            if (this.isSonarCloud) {
                throw new ForbiddenException("You're not authorized to push analysis results to SonarCloud. Please contact your SonarCloud organization administrator.");
            }
            throw new ForbiddenException("You're not authorized to push analysis results to the SonarQube server. Please contact your SonarQube administrator.");
        }
    }
}

