/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class ActivityStatusAction
implements CeWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final System2 system2;

    public ActivityStatusAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder, System2 system2) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.system2 = system2;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("activity_status").setDescription("Returns CE activity related metrics.<br>Requires 'Administer System' permission or 'Administer' rights on the specified project.").setSince("5.5").setResponseExample(this.getClass().getResource("activity_status-example.json")).setHandler((RequestHandler)this);
        action.createParam("componentId").setDescription("Id of the component (project) to filter on").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL0");
        action.createParam("componentKey").setDeprecatedSince("6.6").setDescription("Key of the component (project) to filter on").setExampleValue((Object)"my_project");
        action.setChangelog(new Change[]{new Change("6.6", "New field 'inProgress' in response")});
        action.setChangelog(new Change[]{new Change("7.8", "New field 'pendingTime' in response, only included when there are pending tasks")});
    }

    public void handle(org.sonar.api.server.ws.Request request, Response response) throws Exception {
        Ce.ActivityStatusWsResponse activityStatusResponse = this.doHandle(ActivityStatusAction.toWsRequest(request));
        WsUtils.writeProtobuf((Message)activityStatusResponse, request, response);
    }

    private Ce.ActivityStatusWsResponse doHandle(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional<ComponentDto> component = this.searchComponent(dbSession, request);
            String componentUuid = component.map(ComponentDto::uuid).orElse(null);
            this.checkPermissions(component);
            int pendingCount = this.dbClient.ceQueueDao().countByStatusAndMainComponentUuid(dbSession, CeQueueDto.Status.PENDING, componentUuid);
            int inProgressCount = this.dbClient.ceQueueDao().countByStatusAndMainComponentUuid(dbSession, CeQueueDto.Status.IN_PROGRESS, componentUuid);
            int failingCount = this.dbClient.ceActivityDao().countLastByStatusAndMainComponentUuid(dbSession, CeActivityDto.Status.FAILED, componentUuid);
            Optional creationDate = this.dbClient.ceQueueDao().selectCreationDateOfOldestPendingByMainComponentUuid(dbSession, componentUuid);
            Ce.ActivityStatusWsResponse.Builder builder = Ce.ActivityStatusWsResponse.newBuilder().setPending(pendingCount).setInProgress(inProgressCount).setFailing(failingCount);
            creationDate.ifPresent(d -> {
                long ageOfOldestPendingTime = this.system2.now() - d;
                builder.setPendingTime(ageOfOldestPendingTime);
            });
            Ce.ActivityStatusWsResponse activityStatusWsResponse = builder.build();
            return activityStatusWsResponse;
        }
    }

    private Optional<ComponentDto> searchComponent(DbSession dbSession, Request request) {
        ComponentDto component = null;
        if (ActivityStatusAction.hasComponentInRequest(request)) {
            component = this.componentFinder.getByUuidOrKey(dbSession, request.getComponentId(), request.getComponentKey(), ComponentFinder.ParamNames.COMPONENT_ID_AND_KEY);
        }
        return Optional.ofNullable(component);
    }

    private void checkPermissions(Optional<ComponentDto> component) {
        if (component.isPresent()) {
            this.userSession.checkComponentPermission("admin", component.get());
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private static boolean hasComponentInRequest(Request request) {
        return request.getComponentId() != null || request.getComponentKey() != null;
    }

    private static Request toWsRequest(org.sonar.api.server.ws.Request request) {
        return new Request(request.param("componentId"), request.param("componentKey"));
    }

    private static class Request {
        private String componentId;
        private String componentKey;

        Request(@Nullable String componentId, @Nullable String componentKey) {
            this.componentId = componentId;
            this.componentKey = componentKey;
        }

        @CheckForNull
        public String getComponentId() {
            return this.componentId;
        }

        @CheckForNull
        public String getComponentKey() {
            return this.componentKey;
        }
    }
}

