/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.api.utils.System2;
import org.sonar.server.component.index.ComponentHit;
import org.sonar.server.component.index.ComponentHitsPerQualifier;
import org.sonar.server.component.index.ComponentIndexDefinition;
import org.sonar.server.component.index.ComponentIndexResults;
import org.sonar.server.component.index.ComponentQuery;
import org.sonar.server.component.index.SuggestionQuery;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.textsearch.ComponentTextSearchFeature;
import org.sonar.server.es.textsearch.ComponentTextSearchFeatureRepertoire;
import org.sonar.server.es.textsearch.ComponentTextSearchQueryFactory;
import org.sonar.server.permission.index.WebAuthorizationTypeSupport;

public class ComponentIndex {
    private static final String FILTERS_AGGREGATION_NAME = "filters";
    private static final String DOCS_AGGREGATION_NAME = "docs";
    private final EsClient client;
    private final WebAuthorizationTypeSupport authorizationTypeSupport;
    private final System2 system2;

    public ComponentIndex(EsClient client, WebAuthorizationTypeSupport authorizationTypeSupport, System2 system2) {
        this.client = client;
        this.authorizationTypeSupport = authorizationTypeSupport;
        this.system2 = system2;
    }

    public SearchIdResult<String> search(ComponentQuery query, SearchOptions searchOptions) {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(ComponentIndexDefinition.TYPE_COMPONENT.getMainType()).setFetchSource(false).setFrom(searchOptions.getOffset()).setSize(searchOptions.getLimit());
        BoolQueryBuilder esQuery = QueryBuilders.boolQuery();
        esQuery.filter(this.authorizationTypeSupport.createQueryFilter());
        ComponentIndex.setNullable(query.getQuery(), q -> {
            ComponentTextSearchQueryFactory.ComponentTextSearchQuery componentTextSearchQuery = ComponentTextSearchQueryFactory.ComponentTextSearchQuery.builder().setQueryText(q).setFieldKey("key").setFieldName("name").build();
            esQuery.must(ComponentTextSearchQueryFactory.createQuery((ComponentTextSearchQueryFactory.ComponentTextSearchQuery)componentTextSearchQuery, (ComponentTextSearchFeature[])ComponentTextSearchFeatureRepertoire.values()));
        });
        ComponentIndex.setEmptiable(query.getQualifiers(), q -> esQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"qualifier", (Collection)q)));
        ComponentIndex.setNullable(query.getLanguage(), l -> esQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"language", (String)l)));
        ComponentIndex.setNullable(query.getOrganizationUuid(), o -> esQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"organization_uuid", (String)o)));
        requestBuilder.setQuery((QueryBuilder)esQuery);
        requestBuilder.addSort(DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("name"), SortOrder.ASC);
        return new SearchIdResult((SearchResponse)requestBuilder.get(), id -> id, this.system2.getDefaultTimeZone());
    }

    public ComponentIndexResults searchSuggestions(SuggestionQuery query) {
        return this.searchSuggestions(query, (ComponentTextSearchFeature[])ComponentTextSearchFeatureRepertoire.values());
    }

    @VisibleForTesting
    ComponentIndexResults searchSuggestions(SuggestionQuery query, ComponentTextSearchFeature ... features) {
        Collection qualifiers = query.getQualifiers();
        if (qualifiers.isEmpty()) {
            return ComponentIndexResults.newBuilder().build();
        }
        SearchRequestBuilder request = this.client.prepareSearch(ComponentIndexDefinition.TYPE_COMPONENT.getMainType()).setQuery(this.createQuery(query, features)).addAggregation((AggregationBuilder)ComponentIndex.createAggregation(query)).setSize(0);
        SearchResponse response = (SearchResponse)request.get();
        return ComponentIndex.aggregationsToQualifiers(response);
    }

    private static HighlightBuilder.Field createHighlighterField() {
        HighlightBuilder.Field field = new HighlightBuilder.Field("name");
        field.highlighterType("fvh");
        field.matchedFields((String[])Stream.concat(Stream.of("name"), Arrays.stream(ComponentIndexDefinition.NAME_ANALYZERS).map(a -> a.subField("name"))).toArray(String[]::new));
        return field;
    }

    private static FiltersAggregationBuilder createAggregation(SuggestionQuery query) {
        return (FiltersAggregationBuilder)AggregationBuilders.filters((String)FILTERS_AGGREGATION_NAME, (FiltersAggregator.KeyedFilter[])((FiltersAggregator.KeyedFilter[])query.getQualifiers().stream().map(q -> new FiltersAggregator.KeyedFilter(q, (QueryBuilder)QueryBuilders.termQuery((String)"qualifier", (String)q))).toArray(FiltersAggregator.KeyedFilter[]::new))).subAggregation((AggregationBuilder)ComponentIndex.createSubAggregation(query));
    }

    private static TopHitsAggregationBuilder createSubAggregation(SuggestionQuery query) {
        return AggregationBuilders.topHits((String)DOCS_AGGREGATION_NAME).highlighter(((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().encoder("html").preTags(new String[]{"<mark>"})).postTags(new String[]{"</mark>"})).field(ComponentIndex.createHighlighterField())).from(query.getSkip()).size(query.getLimit()).sort((SortBuilder)new ScoreSortBuilder()).sort((SortBuilder)new FieldSortBuilder("name")).fetchSource(false);
    }

    private QueryBuilder createQuery(SuggestionQuery query, ComponentTextSearchFeature ... features) {
        BoolQueryBuilder esQuery = QueryBuilders.boolQuery();
        esQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"indexType", (String)ComponentIndexDefinition.TYPE_COMPONENT.getName()));
        esQuery.filter(this.authorizationTypeSupport.createQueryFilter());
        ComponentTextSearchQueryFactory.ComponentTextSearchQuery componentTextSearchQuery = ComponentTextSearchQueryFactory.ComponentTextSearchQuery.builder().setQueryText(query.getQuery()).setFieldKey("key").setFieldName("name").setRecentlyBrowsedKeys(query.getRecentlyBrowsedKeys()).setFavoriteKeys(query.getFavoriteKeys()).build();
        return esQuery.must(ComponentTextSearchQueryFactory.createQuery((ComponentTextSearchQueryFactory.ComponentTextSearchQuery)componentTextSearchQuery, (ComponentTextSearchFeature[])features));
    }

    private static ComponentIndexResults aggregationsToQualifiers(SearchResponse response) {
        InternalFilters filtersAgg = (InternalFilters)response.getAggregations().get(FILTERS_AGGREGATION_NAME);
        List buckets = filtersAgg.getBuckets();
        return ComponentIndexResults.newBuilder().setQualifiers(buckets.stream().map(ComponentIndex::bucketToQualifier)).build();
    }

    private static ComponentHitsPerQualifier bucketToQualifier(InternalFilters.InternalBucket bucket) {
        InternalTopHits docs = (InternalTopHits)bucket.getAggregations().get(DOCS_AGGREGATION_NAME);
        SearchHits hitList = docs.getHits();
        SearchHit[] hits = hitList.getHits();
        return new ComponentHitsPerQualifier(bucket.getKey(), ComponentHit.fromSearchHits((SearchHit[])hits), hitList.getTotalHits());
    }

    private static <T> void setNullable(@Nullable T parameter, Consumer<T> consumer) {
        if (parameter != null) {
            consumer.accept(parameter);
        }
    }

    private static <T> void setEmptiable(Collection<T> parameter, Consumer<Collection<T>> consumer) {
        if (!parameter.isEmpty()) {
            consumer.accept(parameter);
        }
    }
}

