/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.server.component.ws.FilterParser;
import org.sonar.server.measure.index.ProjectMeasuresQuery;

class ProjectMeasuresQueryFactory {
    public static final String IS_FAVORITE_CRITERION = "isFavorite";
    public static final String QUERY_KEY = "query";
    private static final String NO_DATA = "NO_DATA";
    private static final Map<String, BiConsumer<FilterParser.Criterion, ProjectMeasuresQuery>> CRITERION_PROCESSORS = ImmutableMap.builder().put((Object)"isFavorite".toLowerCase(Locale.ENGLISH), (criterion, query) -> ProjectMeasuresQueryFactory.processIsFavorite(criterion)).put((Object)"languages", ProjectMeasuresQueryFactory::processLanguages).put((Object)"tags", ProjectMeasuresQueryFactory::processTags).put((Object)"query", ProjectMeasuresQueryFactory::processQuery).put((Object)"alert_status", ProjectMeasuresQueryFactory::processQualityGateStatus).build();

    private ProjectMeasuresQueryFactory() {
    }

    static ProjectMeasuresQuery newProjectMeasuresQuery(List<FilterParser.Criterion> criteria, @Nullable Set<String> projectUuids) {
        ProjectMeasuresQuery query = new ProjectMeasuresQuery();
        Optional.ofNullable(projectUuids).ifPresent(query::setProjectUuids);
        criteria.forEach(criterion -> ProjectMeasuresQueryFactory.processCriterion(criterion, query));
        return query;
    }

    private static void processCriterion(FilterParser.Criterion criterion, ProjectMeasuresQuery query) {
        String key = criterion.getKey().toLowerCase(Locale.ENGLISH);
        CRITERION_PROCESSORS.getOrDefault(key, ProjectMeasuresQueryFactory::processMetricCriterion).accept(criterion, query);
    }

    private static void processIsFavorite(FilterParser.Criterion criterion) {
        Preconditions.checkArgument((criterion.getOperator() == null && criterion.getValue() == null ? 1 : 0) != 0, (Object)"Filter on favorites should be declared without an operator nor a value");
    }

    private static void processLanguages(FilterParser.Criterion criterion, ProjectMeasuresQuery query) {
        ProjectMeasuresQueryFactory.checkOperator(criterion);
        ProjectMeasuresQuery.Operator operator = criterion.getOperator();
        String value = criterion.getValue();
        List<String> values = criterion.getValues();
        if (value != null && ProjectMeasuresQuery.Operator.EQ.equals((Object)operator)) {
            query.setLanguages(Collections.singleton(value));
            return;
        }
        if (!values.isEmpty() && ProjectMeasuresQuery.Operator.IN.equals((Object)operator)) {
            query.setLanguages(new HashSet<String>(values));
            return;
        }
        throw new IllegalArgumentException("Languages should be set either by using 'languages = java' or 'languages IN (java, js)'");
    }

    private static void processTags(FilterParser.Criterion criterion, ProjectMeasuresQuery query) {
        ProjectMeasuresQueryFactory.checkOperator(criterion);
        ProjectMeasuresQuery.Operator operator = criterion.getOperator();
        String value = criterion.getValue();
        List<String> values = criterion.getValues();
        if (value != null && ProjectMeasuresQuery.Operator.EQ.equals((Object)operator)) {
            query.setTags(Collections.singleton(value));
            return;
        }
        if (!values.isEmpty() && ProjectMeasuresQuery.Operator.IN.equals((Object)operator)) {
            query.setTags(new HashSet<String>(values));
            return;
        }
        throw new IllegalArgumentException("Tags should be set either by using 'tags = java' or 'tags IN (finance, platform)'");
    }

    private static void processQuery(FilterParser.Criterion criterion, ProjectMeasuresQuery query) {
        ProjectMeasuresQueryFactory.checkOperator(criterion);
        ProjectMeasuresQuery.Operator operatorValue = criterion.getOperator();
        String value = criterion.getValue();
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Query is invalid");
        Preconditions.checkArgument((boolean)ProjectMeasuresQuery.Operator.EQ.equals((Object)operatorValue), (Object)"Query should only be used with equals operator");
        query.setQueryText(value);
    }

    private static void processQualityGateStatus(FilterParser.Criterion criterion, ProjectMeasuresQuery query) {
        ProjectMeasuresQueryFactory.checkOperator(criterion);
        ProjectMeasuresQueryFactory.checkValue(criterion);
        ProjectMeasuresQuery.Operator operator = criterion.getOperator();
        String value = criterion.getValue();
        Preconditions.checkArgument((boolean)ProjectMeasuresQuery.Operator.EQ.equals((Object)operator), (Object)"Only equals operator is available for quality gate criteria");
        Metric.Level qualityGate = Arrays.stream(Metric.Level.values()).filter(level -> level.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown quality gate status : '%s'", value)));
        query.setQualityGateStatus(qualityGate);
    }

    private static void processMetricCriterion(FilterParser.Criterion criterion, ProjectMeasuresQuery query) {
        ProjectMeasuresQueryFactory.checkOperator(criterion);
        ProjectMeasuresQueryFactory.checkValue(criterion);
        query.addMetricCriterion(ProjectMeasuresQueryFactory.createMetricCriterion(criterion, criterion.getKey().toLowerCase(Locale.ENGLISH), criterion.getOperator()));
    }

    private static ProjectMeasuresQuery.MetricCriterion createMetricCriterion(FilterParser.Criterion criterion, String metricKey, ProjectMeasuresQuery.Operator operator) {
        if (NO_DATA.equalsIgnoreCase(criterion.getValue())) {
            Preconditions.checkArgument((boolean)ProjectMeasuresQuery.Operator.EQ.equals((Object)operator), (String)"%s can only be used with equals operator", (Object[])new Object[]{NO_DATA});
            return ProjectMeasuresQuery.MetricCriterion.createNoData(metricKey);
        }
        return ProjectMeasuresQuery.MetricCriterion.create(metricKey, operator, ProjectMeasuresQueryFactory.parseValue(criterion.getValue()));
    }

    private static double parseValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Value '%s' is not a number", value));
        }
    }

    private static void checkValue(FilterParser.Criterion criterion) {
        Preconditions.checkArgument((criterion.getValue() != null ? 1 : 0) != 0, (String)"Value cannot be null for '%s'", (Object[])new Object[]{criterion.getKey()});
    }

    private static void checkOperator(FilterParser.Criterion criterion) {
        Preconditions.checkArgument((criterion.getOperator() != null ? 1 : 0) != 0, (String)"Operator cannot be null for '%s'", (Object[])new Object[]{criterion.getKey()});
    }
}

