/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.duplication.ws.DuplicationsParser;
import org.sonar.server.duplication.ws.DuplicationsWsAction;
import org.sonar.server.duplication.ws.ShowResponseBuilder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class ShowAction
implements DuplicationsWsAction {
    private static final String PARAM_KEY = "key";
    private static final String PARAM_UUID = "uuid";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_PULL_REQUEST = "pullRequest";
    private final DbClient dbClient;
    private final DuplicationsParser parser;
    private final ShowResponseBuilder responseBuilder;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public ShowAction(DbClient dbClient, DuplicationsParser parser, ShowResponseBuilder responseBuilder, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.parser = parser;
        this.responseBuilder = responseBuilder;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setDescription("Get duplications. Require Browse permission on file's project").setSince("4.4").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("show-example.json"));
        action.setChangelog(new Change[]{new Change("6.5", "The fields 'uuid', 'projectUuid', 'subProjectUuid' are deprecated in the response.")});
        action.createParam(PARAM_KEY).setDescription("File key").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam(PARAM_UUID).setDeprecatedSince("6.5").setDescription("File ID. If provided, 'key' must not be provided.").setExampleValue((Object)"584a89f2-8037-4f7b-b82c-8b45d2d63fb2");
        action.createParam(PARAM_BRANCH).setDescription("Branch key").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_PULL_REQUEST).setDescription("Pull request id").setInternal(true).setSince("7.1").setExampleValue((Object)"5461");
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            this.userSession.checkComponentPermission("codeviewer", component);
            String duplications = this.findDataFromComponent(dbSession, component);
            String branch = component.getBranch();
            String pullRequest = component.getPullRequest();
            List<DuplicationsParser.Block> blocks = this.parser.parse(dbSession, component, branch, pullRequest, duplications);
            WsUtils.writeProtobuf((Message)this.responseBuilder.build(dbSession, blocks, branch, pullRequest), request, response);
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentUuid = request.param(PARAM_UUID);
        String branch = request.param(PARAM_BRANCH);
        String pullRequest = request.param(PARAM_PULL_REQUEST);
        Preconditions.checkArgument((componentUuid == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{PARAM_UUID, PARAM_BRANCH, PARAM_PULL_REQUEST});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentUuid, request.param(PARAM_KEY), ComponentFinder.ParamNames.UUID_AND_KEY);
        }
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, request.mandatoryParam(PARAM_KEY), branch, pullRequest);
    }

    @CheckForNull
    private String findDataFromComponent(DbSession dbSession, ComponentDto component) {
        return this.dbClient.liveMeasureDao().selectMeasure(dbSession, component.uuid(), "duplications_data").map(LiveMeasureDto::getDataAsString).orElse(null);
    }
}

