/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.Condition;
import org.sonar.server.issue.workflow.IsUnResolved;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class AssignAction
extends Action {
    public static final String ASSIGN_KEY = "assign";
    public static final String ASSIGNEE_PARAMETER = "assignee";
    private static final String VERIFIED_ASSIGNEE = "verifiedAssignee";
    private static final String ASSIGNEE_ORGANIZATIONS = "assigneeOrganizationUuids";
    private final DbClient dbClient;
    private final IssueFieldsSetter issueFieldsSetter;

    public AssignAction(DbClient dbClient, IssueFieldsSetter issueFieldsSetter) {
        super(ASSIGN_KEY);
        this.dbClient = dbClient;
        this.issueFieldsSetter = issueFieldsSetter;
        super.setConditions(new Condition[]{new IsUnResolved()});
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        String assigneeLogin = AssignAction.getAssigneeValue(properties);
        UserDto assignee = Strings.isNullOrEmpty((String)assigneeLogin) ? null : this.getUser(assigneeLogin);
        properties.put(VERIFIED_ASSIGNEE, assignee);
        properties.put(ASSIGNEE_ORGANIZATIONS, this.loadUserOrganizations(assignee));
        return true;
    }

    private static String getAssigneeValue(Map<String, Object> properties) {
        return (String)properties.get(ASSIGNEE_PARAMETER);
    }

    private UserDto getUser(String assigneeKey) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = WsUtils.checkFound(this.dbClient.userDao().selectActiveUserByLogin(dbSession, assigneeKey), "Unknown user: %s", assigneeKey);
            return userDto;
        }
    }

    private Set<String> loadUserOrganizations(@Nullable UserDto assignee) {
        if (assignee == null) {
            return Collections.emptySet();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set set = this.dbClient.organizationMemberDao().selectOrganizationUuidsByUser(dbSession, assignee.getId().intValue());
            return set;
        }
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        Preconditions.checkArgument((boolean)properties.containsKey(VERIFIED_ASSIGNEE), (Object)"Assignee is missing from the execution parameters");
        UserDto assignee = (UserDto)properties.get(VERIFIED_ASSIGNEE);
        return AssignAction.isAssigneeMemberOfIssueOrganization(assignee, properties, context) && this.issueFieldsSetter.assign(context.issue(), assignee, context.issueChangeContext());
    }

    @Override
    public boolean shouldRefreshMeasures() {
        return false;
    }

    private static boolean isAssigneeMemberOfIssueOrganization(@Nullable UserDto assignee, Map<String, Object> properties, Action.Context context) {
        return assignee == null || ((Set)properties.get(ASSIGNEE_ORGANIZATIONS)).contains(context.project().getOrganizationUuid());
    }
}

