/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.live;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.Collections2;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.Rating;

class MeasureMatrix {
    private final Table<String, String, MeasureCell> table;
    private final Map<String, MetricDto> metricsByKeys = new HashMap<String, MetricDto>();
    private final Map<Integer, MetricDto> metricsByIds = new HashMap<Integer, MetricDto>();

    MeasureMatrix(Collection<ComponentDto> components, Collection<MetricDto> metrics, List<LiveMeasureDto> dbMeasures) {
        for (MetricDto metric : metrics) {
            this.metricsByKeys.put(metric.getKey(), metric);
            this.metricsByIds.put(metric.getId(), metric);
        }
        this.table = ArrayTable.create((Iterable)Collections2.transform(components, ComponentDto::uuid), this.metricsByKeys.keySet());
        for (LiveMeasureDto dbMeasure : dbMeasures) {
            this.table.put((Object)dbMeasure.getComponentUuid(), (Object)this.metricsByIds.get(dbMeasure.getMetricId()).getKey(), (Object)new MeasureCell(dbMeasure, false));
        }
    }

    MetricDto getMetric(int id) {
        return Objects.requireNonNull(this.metricsByIds.get(id), () -> String.format("Metric with id %d not found", id));
    }

    private MetricDto getMetric(String key) {
        return Objects.requireNonNull(this.metricsByKeys.get(key), () -> String.format("Metric with key %s not found", key));
    }

    Optional<LiveMeasureDto> getMeasure(ComponentDto component, String metricKey) {
        Preconditions.checkArgument((boolean)this.table.containsColumn((Object)metricKey), (String)"Metric with key %s is not registered", (Object[])new Object[]{metricKey});
        MeasureCell cell = (MeasureCell)this.table.get((Object)component.uuid(), (Object)metricKey);
        return cell == null ? Optional.empty() : Optional.of(cell.measure);
    }

    void setValue(ComponentDto component, String metricKey, double value) {
        this.changeCell(component, metricKey, m -> {
            MetricDto metric = this.getMetric(metricKey);
            double newValue = MeasureMatrix.scale(metric, value);
            Double initialValue = m.getValue();
            if (initialValue != null && Double.compare(initialValue, newValue) == 0) {
                return false;
            }
            m.setValue(Double.valueOf(newValue));
            Double initialVariation = m.getVariation();
            if (initialValue != null && initialVariation != null) {
                double leakInitialValue = initialValue - initialVariation;
                m.setVariation(Double.valueOf(MeasureMatrix.scale(metric, value - leakInitialValue)));
            }
            return true;
        });
    }

    void setValue(ComponentDto component, String metricKey, Rating value) {
        this.changeCell(component, metricKey, m -> {
            Double initialValue = m.getValue();
            if (initialValue != null && Double.compare(initialValue, value.getIndex()) == 0) {
                return false;
            }
            m.setData(value.name());
            m.setValue(Double.valueOf(value.getIndex()));
            Double initialVariation = m.getVariation();
            if (initialValue != null && initialVariation != null) {
                double leakInitialValue = initialValue - initialVariation;
                m.setVariation(Double.valueOf((double)value.getIndex() - leakInitialValue));
            }
            return true;
        });
    }

    void setValue(ComponentDto component, String metricKey, @Nullable String data) {
        this.changeCell(component, metricKey, m -> {
            if (Objects.equals(m.getDataAsString(), data)) {
                return false;
            }
            m.setData(data);
            return true;
        });
    }

    void setLeakValue(ComponentDto component, String metricKey, double variation) {
        this.changeCell(component, metricKey, c -> {
            double newVariation = MeasureMatrix.scale(this.getMetric(metricKey), variation);
            if (c.getVariation() != null && Double.compare(c.getVariation(), newVariation) == 0) {
                return false;
            }
            MetricDto metric = this.metricsByKeys.get(metricKey);
            c.setVariation(Double.valueOf(MeasureMatrix.scale(metric, variation)));
            return true;
        });
    }

    void setLeakValue(ComponentDto component, String metricKey, Rating variation) {
        this.setLeakValue(component, metricKey, variation.getIndex());
    }

    Stream<LiveMeasureDto> getChanged() {
        return this.table.values().stream().filter(Objects::nonNull).filter(MeasureCell::isChanged).map(MeasureCell::getMeasure);
    }

    private void changeCell(ComponentDto component, String metricKey, Function<LiveMeasureDto, Boolean> changer) {
        MeasureCell cell = (MeasureCell)this.table.get((Object)component.uuid(), (Object)metricKey);
        if (cell == null) {
            LiveMeasureDto measure = new LiveMeasureDto().setComponentUuid(component.uuid()).setProjectUuid(component.projectUuid()).setMetricId(this.metricsByKeys.get(metricKey).getId().intValue());
            cell = new MeasureCell(measure, true);
            this.table.put((Object)component.uuid(), (Object)metricKey, (Object)cell);
            changer.apply(cell.getMeasure());
        } else if (changer.apply(cell.getMeasure()).booleanValue()) {
            cell.setChanged(true);
        }
    }

    private static double scale(MetricDto metric, double value) {
        if (metric.getDecimalScale() == null) {
            return value;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        return bd.setScale((int)metric.getDecimalScale(), RoundingMode.HALF_UP).doubleValue();
    }

    private static class MeasureCell {
        private final LiveMeasureDto measure;
        private boolean changed;

        private MeasureCell(LiveMeasureDto measure, boolean changed) {
            this.measure = measure;
            this.changed = changed;
        }

        public LiveMeasureDto getMeasure() {
            return this.measure;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void setChanged(boolean b) {
            this.changed = b;
        }
    }
}

