/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultContext;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.i18n.I18n;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.MeasureTreeQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.metric.MetricDtoFunctions;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.measure.ws.ComponentDtoToWsComponent;
import org.sonar.server.measure.ws.ComponentTreeData;
import org.sonar.server.measure.ws.ComponentTreeRequest;
import org.sonar.server.measure.ws.ComponentTreeSort;
import org.sonar.server.measure.ws.HasMeasure;
import org.sonar.server.measure.ws.MeasureDtoToWsMeasure;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.MeasuresWsParametersBuilder;
import org.sonar.server.measure.ws.MetricDtoToWsMetric;
import org.sonar.server.measure.ws.MetricDtoWithBestValue;
import org.sonar.server.measure.ws.SLBorPRMeasureFix;
import org.sonar.server.measure.ws.SnapshotDtoToWsPeriod;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Measures;

public class ComponentTreeAction
implements MeasuresWsAction {
    private static final int MAX_SIZE = 500;
    private static final int QUERY_MINIMUM_LENGTH = 3;
    static final String ALL_STRATEGY = "all";
    static final String CHILDREN_STRATEGY = "children";
    static final String LEAVES_STRATEGY = "leaves";
    static final Map<String, ComponentTreeQuery.Strategy> STRATEGIES = ImmutableMap.of((Object)"all", (Object)ComponentTreeQuery.Strategy.LEAVES, (Object)"children", (Object)ComponentTreeQuery.Strategy.CHILDREN, (Object)"leaves", (Object)ComponentTreeQuery.Strategy.LEAVES);
    static final String NAME_SORT = "name";
    static final String PATH_SORT = "path";
    static final String QUALIFIER_SORT = "qualifier";
    static final String METRIC_SORT = "metric";
    static final String METRIC_PERIOD_SORT = "metricPeriod";
    static final Set<String> SORTS = ImmutableSortedSet.of((Comparable)((Object)"name"), (Comparable)((Object)"path"), (Comparable)((Object)"qualifier"), (Comparable)((Object)"metric"), (Comparable)((Object)"metricPeriod"));
    static final String ALL_METRIC_SORT_FILTER = "all";
    static final String WITH_MEASURES_ONLY_METRIC_SORT_FILTER = "withMeasuresOnly";
    static final Set<String> METRIC_SORT_FILTERS = ImmutableSortedSet.of((Comparable)((Object)"all"), (Comparable)((Object)"withMeasuresOnly"));
    static final Set<String> FORBIDDEN_METRIC_TYPES = ImmutableSet.of((Object)Metric.ValueType.DISTRIB.name(), (Object)Metric.ValueType.DATA.name());
    private static final int MAX_METRIC_KEYS = 15;
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final Set<String> QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE = ImmutableSet.of((Object)"FIL", (Object)"UTS");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final I18n i18n;
    private final ResourceTypes resourceTypes;

    public ComponentTreeAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, I18n i18n, ResourceTypes resourceTypes) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.i18n = i18n;
        this.resourceTypes = resourceTypes;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("component_tree").setDescription(String.format("Navigate through components based on the chosen strategy with specified measures. The %s or the %s parameter must be provided.<br>Requires the following permission: 'Browse' on the specified project.<br>When limiting search with the %s parameter, directories are not returned.", "baseComponentId", "component", "q")).setResponseExample(this.getClass().getResource("component_tree-example.json")).setSince("5.4").setHandler((RequestHandler)this).addPagingParams(100, 500).setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component")), new Change("7.2", "field 'bestValue' is added to the response"), new Change("6.3", String.format("Number of metric keys is limited to %s", 15)), new Change("6.6", "the response field id is deprecated. Use key instead."), new Change("6.6", "the response field refId is deprecated. Use refKey instead.")});
        action.createSortParams(SORTS, (Object)NAME_SORT, true).setDescription("Comma-separated list of sort fields").setExampleValue((Object)"name,path");
        action.createParam("q").setDescription("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>").setMinimumLength(Integer.valueOf(3)).setExampleValue((Object)"FILE_NAM");
        action.createParam("baseComponentId").setDescription("Base component id. The search is based on this component.").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz").setDeprecatedSince("6.6");
        action.createParam("component").setDescription("Component key. The search is based on this component.").setExampleValue((Object)"my_project").setDeprecatedKey("baseComponentKey", "6.6");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
        action.createParam("metricSort").setDescription(String.format("Metric key to sort by. The '%s' parameter must contain the '%s' or '%s' value. It must be part of the '%s' parameter", "s", METRIC_SORT, METRIC_PERIOD_SORT, "metricKeys")).setExampleValue((Object)"ncloc");
        action.createParam("metricPeriodSort").setDescription(String.format("Sort measures by leak period or not ?. The '%s' parameter must contain the '%s' value.", "s", METRIC_PERIOD_SORT)).setSince("5.5").setPossibleValues((Object[])new Integer[]{1});
        action.createParam("metricSortFilter").setDescription(String.format("Filter components. Sort must be on a metric. Possible values are: <ul><li>%s: return all components</li><li>%s: filter out components that do not have a measure on the sorted metric</li></ul>", "all", WITH_MEASURES_ONLY_METRIC_SORT_FILTER)).setDefaultValue((Object)"all").setPossibleValues(METRIC_SORT_FILTERS);
        MeasuresWsParametersBuilder.createMetricKeysParameter(action).setDescription("Comma-separated list of metric keys. Types %s are not allowed.", new Object[]{COMMA_JOINER.join(FORBIDDEN_METRIC_TYPES)}).setMaxValuesAllowed(Integer.valueOf(15));
        MeasuresWsParametersBuilder.createAdditionalFieldsParameter(action);
        MeasuresWsParametersBuilder.createDeveloperParameters(action);
        WsParameterBuilder.createQualifiersParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes));
        action.createParam("strategy").setDescription("Strategy to search for base component descendants:<ul><li>children: return the children components of the base component. Grandchildren components are not returned</li><li>all: return all the descendants components of the base component. Grandchildren are returned.</li><li>leaves: return all the descendant components (files, in general) which don't have other children. They are the leaves of the component tree.</li></ul>").setPossibleValues(STRATEGIES.keySet()).setDefaultValue((Object)"all");
    }

    public void handle(Request request, Response response) throws Exception {
        Measures.ComponentTreeWsResponse componentTreeWsResponse = this.doHandle(ComponentTreeAction.toComponentTreeWsRequest(request));
        WsUtils.writeProtobuf((Message)componentTreeWsResponse, request, response);
    }

    private Measures.ComponentTreeWsResponse doHandle(ComponentTreeRequest request) {
        if (request.getDeveloperId() != null || request.getDeveloperKey() != null) {
            return ComponentTreeAction.emptyResponse(null, request);
        }
        ComponentTreeData data = this.load(request);
        if (data.getComponents() == null) {
            return ComponentTreeAction.emptyResponse(data.getBaseComponent(), request);
        }
        return ComponentTreeAction.buildResponse(request, data, Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal(data.getComponentCount()));
    }

    private static Measures.ComponentTreeWsResponse buildResponse(ComponentTreeRequest request, ComponentTreeData data, Paging paging) {
        Measures.ComponentTreeWsResponse.Builder response = Measures.ComponentTreeWsResponse.newBuilder();
        response.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        response.setBaseComponent(ComponentTreeAction.toWsComponent(data.getBaseComponent(), data.getMeasuresByComponentUuidAndMetric().row((Object)data.getBaseComponent().uuid()), data.getReferenceComponentsByUuid()));
        for (ComponentDto componentDto : data.getComponents()) {
            response.addComponents(ComponentTreeAction.toWsComponent(componentDto, data.getMeasuresByComponentUuidAndMetric().row((Object)componentDto.uuid()), data.getReferenceComponentsByUuid()));
        }
        if (ComponentTreeAction.areMetricsInResponse(request)) {
            Measures.Metrics.Builder metricsBuilder = response.getMetricsBuilder();
            for (MetricDto metricDto : data.getMetrics()) {
                metricsBuilder.addMetrics(MetricDtoToWsMetric.metricDtoToWsMetric(metricDto));
            }
        }
        if (ComponentTreeAction.arePeriodsInResponse(request) && data.getPeriod() != null) {
            response.getPeriodsBuilder().addPeriods(data.getPeriod());
        }
        return response.build();
    }

    private static boolean areMetricsInResponse(ComponentTreeRequest request) {
        List<String> additionalFields = request.getAdditionalFields();
        return additionalFields != null && additionalFields.contains("metrics");
    }

    private static boolean arePeriodsInResponse(ComponentTreeRequest request) {
        List<String> additionalFields = request.getAdditionalFields();
        return additionalFields != null && additionalFields.contains("periods");
    }

    private static Measures.ComponentTreeWsResponse emptyResponse(@Nullable ComponentDto baseComponent, ComponentTreeRequest request) {
        Measures.ComponentTreeWsResponse.Builder response = Measures.ComponentTreeWsResponse.newBuilder();
        response.getPagingBuilder().setPageIndex(request.getPage().intValue()).setPageSize(request.getPageSize().intValue()).setTotal(0);
        if (baseComponent != null) {
            response.setBaseComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(baseComponent));
        }
        return response.build();
    }

    private static ComponentTreeRequest toComponentTreeWsRequest(Request request) {
        List metricKeys = request.mandatoryParamAsStrings("metricKeys");
        Preconditions.checkArgument((metricKeys.size() <= 15 ? 1 : 0) != 0, (String)"Number of metrics keys is limited to %s, got %s", (Object[])new Object[]{15, metricKeys.size()});
        ComponentTreeRequest componentTreeRequest = new ComponentTreeRequest().setBaseComponentId(request.param("baseComponentId")).setComponent(request.param("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest")).setMetricKeys(metricKeys).setStrategy(request.mandatoryParam("strategy")).setQualifiers(request.paramAsStrings("qualifiers")).setAdditionalFields(request.paramAsStrings("additionalFields")).setSort(request.paramAsStrings("s")).setAsc(request.paramAsBoolean("asc")).setMetricSort(request.param("metricSort")).setMetricSortFilter(request.mandatoryParam("metricSortFilter")).setMetricPeriodSort(request.paramAsInt("metricPeriodSort")).setDeveloperId(request.param("developerId")).setDeveloperKey(request.param("developerKey")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setQuery(request.param("q"));
        String metricSortValue = componentTreeRequest.getMetricSort();
        WsUtils.checkRequest(!componentTreeRequest.getMetricKeys().isEmpty(), "The '%s' parameter must contain at least one metric key", "metricKeys");
        List sorts = Optional.ofNullable(componentTreeRequest.getSort()).orElse(Collections.emptyList());
        WsUtils.checkRequest(metricSortValue == null ^ sorts.contains(METRIC_SORT) ^ sorts.contains(METRIC_PERIOD_SORT), "To sort by a metric, the '%s' parameter must contain '%s' or '%s', and a metric key must be provided in the '%s' parameter", "s", METRIC_SORT, METRIC_PERIOD_SORT, "metricSort");
        WsUtils.checkRequest(metricSortValue == null ^ componentTreeRequest.getMetricKeys().contains(metricSortValue), "To sort by the '%s' metric, it must be in the list of metric keys in the '%s' parameter", metricSortValue, "metricKeys");
        WsUtils.checkRequest(componentTreeRequest.getMetricPeriodSort() == null ^ sorts.contains(METRIC_PERIOD_SORT), "To sort by a metric period, the '%s' parameter must contain '%s' and the '%s' must be provided.", "s", METRIC_PERIOD_SORT, "metricPeriodSort");
        WsUtils.checkRequest("all".equals(componentTreeRequest.getMetricSortFilter()) || metricSortValue != null, "To filter components based on the sort metric, the '%s' parameter must contain '%s' or '%s' and the '%s' parameter must be provided", "s", METRIC_SORT, METRIC_PERIOD_SORT, "metricSort");
        return componentTreeRequest;
    }

    private static Measures.Component.Builder toWsComponent(ComponentDto component, Map<MetricDto, ComponentTreeData.Measure> measures, Map<String, ComponentDto> referenceComponentsByUuid) {
        Measures.Component.Builder wsComponent = ComponentDtoToWsComponent.componentDtoToWsComponent(component);
        ComponentDto referenceComponent = referenceComponentsByUuid.get(component.getCopyResourceUuid());
        if (referenceComponent != null) {
            wsComponent.setRefId(referenceComponent.uuid());
            wsComponent.setRefKey(referenceComponent.getKey());
        }
        Measures.Measure.Builder measureBuilder = Measures.Measure.newBuilder();
        for (Map.Entry<MetricDto, ComponentTreeData.Measure> entry : measures.entrySet()) {
            ComponentTreeData.Measure measure = entry.getValue();
            MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, entry.getKey(), measure.getValue(), measure.getData(), measure.getVariation());
            wsComponent.addMeasures(measureBuilder);
            measureBuilder.clear();
        }
        return wsComponent;
    }

    private ComponentTreeData load(ComponentTreeRequest wsRequest) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto baseComponent = this.loadComponent(dbSession, wsRequest);
            this.checkPermissions(baseComponent);
            Optional baseSnapshot = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, baseComponent.projectUuid());
            if (!baseSnapshot.isPresent()) {
                ComponentTreeData componentTreeData = ComponentTreeData.builder().setBaseComponent(baseComponent).build();
                return componentTreeData;
            }
            HashSet<String> requestedMetricKeys = new HashSet<String>(wsRequest.getMetricKeys());
            HashSet<String> metricKeysToSearch = new HashSet<String>(requestedMetricKeys);
            boolean isSLBorPR = this.isSLBorPR(dbSession, baseComponent, wsRequest.getBranch(), wsRequest.getPullRequest());
            if (isSLBorPR) {
                SLBorPRMeasureFix.addReplacementMetricKeys(metricKeysToSearch);
            }
            ComponentTreeQuery componentTreeQuery = this.toComponentTreeQuery(wsRequest, baseComponent);
            List<ComponentDto> components = this.searchComponents(dbSession, componentTreeQuery);
            List<MetricDto> metrics = this.searchMetrics(dbSession, metricKeysToSearch);
            Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric = this.searchMeasuresByComponentUuidAndMetric(dbSession, baseComponent, componentTreeQuery, components, metrics);
            if (isSLBorPR) {
                SLBorPRMeasureFix.removeMetricsNotRequested(metrics, requestedMetricKeys);
                SLBorPRMeasureFix.createReplacementMeasures(metrics, measuresByComponentUuidAndMetric, requestedMetricKeys);
            }
            components = ComponentTreeAction.filterComponents(components, measuresByComponentUuidAndMetric, metrics, wsRequest);
            components = ComponentTreeAction.sortComponents(components, wsRequest, metrics, measuresByComponentUuidAndMetric);
            int componentCount = components.size();
            components = ComponentTreeAction.paginateComponents(components, wsRequest);
            ComponentTreeData componentTreeData = ComponentTreeData.builder().setBaseComponent(baseComponent).setComponentsFromDb(components).setComponentCount(componentCount).setMeasuresByComponentUuidAndMetric(measuresByComponentUuidAndMetric).setMetrics(metrics).setPeriod(SnapshotDtoToWsPeriod.snapshotToWsPeriods((SnapshotDto)baseSnapshot.get()).orElse(null)).setReferenceComponentsByUuid(this.searchReferenceComponentsById(dbSession, components)).build();
            return componentTreeData;
        }
    }

    private boolean isSLBorPR(DbSession dbSession, ComponentDto component, @Nullable String branch, @Nullable String pullRequest) {
        if (branch != null) {
            return this.dbClient.branchDao().selectByUuid(dbSession, component.projectUuid()).map(b -> b.getBranchType() == BranchType.SHORT).orElse(false);
        }
        return pullRequest != null;
    }

    private ComponentDto loadComponent(DbSession dbSession, ComponentTreeRequest request) {
        String componentId = request.getBaseComponentId();
        String componentKey = request.getComponent();
        String branch = request.getBranch();
        String pullRequest = request.getPullRequest();
        Preconditions.checkArgument((componentId == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{"baseComponentId", "branch", "pullRequest"});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.BASE_COMPONENT_ID_AND_KEY);
        }
        WsUtils.checkRequest(componentKey != null, "The '%s' parameter is missing", "component");
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, branch, pullRequest);
    }

    private Map<String, ComponentDto> searchReferenceComponentsById(DbSession dbSession, List<ComponentDto> components) {
        List referenceComponentUUids = (List)components.stream().map(ComponentDto::getCopyResourceUuid).filter(Objects::nonNull).collect(MoreCollectors.toList((int)components.size()));
        if (referenceComponentUUids.isEmpty()) {
            return Collections.emptyMap();
        }
        return FluentIterable.from((Iterable)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)referenceComponentUUids)).uniqueIndex(ComponentDto::uuid);
    }

    private List<ComponentDto> searchComponents(DbSession dbSession, ComponentTreeQuery componentTreeQuery) {
        Collection qualifiers = componentTreeQuery.getQualifiers();
        if (qualifiers != null && qualifiers.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dbClient.componentDao().selectDescendants(dbSession, componentTreeQuery);
    }

    private List<MetricDto> searchMetrics(DbSession dbSession, Set<String> metricKeys) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, metricKeys);
        if (metrics.size() < metricKeys.size()) {
            List foundMetricKeys = Lists.transform((List)metrics, MetricDto::getKey);
            Sets.SetView missingMetricKeys = Sets.difference(new LinkedHashSet<String>(metricKeys), new LinkedHashSet(foundMetricKeys));
            throw new NotFoundException(String.format("The following metric keys are not found: %s", COMMA_JOINER.join((Iterable)missingMetricKeys)));
        }
        String forbiddenMetrics = (String)metrics.stream().filter(metric -> FORBIDDEN_METRIC_TYPES.contains(metric.getValueType())).map(MetricDto::getKey).sorted().collect(MoreCollectors.join((Joiner)COMMA_JOINER));
        Preconditions.checkArgument((boolean)forbiddenMetrics.isEmpty(), (String)"Metrics %s can't be requested in this web service. Please use api/measures/component", (Object[])new Object[]{forbiddenMetrics});
        return metrics;
    }

    private Table<String, MetricDto, ComponentTreeData.Measure> searchMeasuresByComponentUuidAndMetric(DbSession dbSession, ComponentDto baseComponent, ComponentTreeQuery componentTreeQuery, List<ComponentDto> components, List<MetricDto> metrics) {
        ImmutableMap metricsById = Maps.uniqueIndex(metrics, MetricDto::getId);
        MeasureTreeQuery measureQuery = MeasureTreeQuery.builder().setStrategy(MeasureTreeQuery.Strategy.valueOf((String)componentTreeQuery.getStrategy().name())).setNameOrKeyQuery(componentTreeQuery.getNameOrKeyQuery()).setQualifiers(componentTreeQuery.getQualifiers()).setMetricIds(new ArrayList(metricsById.keySet())).build();
        HashBasedTable measuresByComponentUuidAndMetric = HashBasedTable.create((int)components.size(), (int)metrics.size());
        this.dbClient.liveMeasureDao().selectTreeByQuery(dbSession, baseComponent, measureQuery, arg_0 -> ComponentTreeAction.lambda$searchMeasuresByComponentUuidAndMetric$2((Table)measuresByComponentUuidAndMetric, (Map)metricsById, arg_0));
        ComponentTreeAction.addBestValuesToMeasures((Table<String, MetricDto, ComponentTreeData.Measure>)measuresByComponentUuidAndMetric, components, metrics);
        return measuresByComponentUuidAndMetric;
    }

    private static void addBestValuesToMeasures(Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric, List<ComponentDto> components, List<MetricDto> metrics) {
        List metricDtosWithBestValueMeasure = (List)metrics.stream().filter(MetricDtoFunctions.isOptimizedForBestValue()).map(new MetricDtoToMetricDtoWithBestValue()).collect(MoreCollectors.toList((int)metrics.size()));
        if (metricDtosWithBestValueMeasure.isEmpty()) {
            return;
        }
        Stream<ComponentDto> componentsEligibleForBestValue = components.stream().filter(ComponentTreeAction::isFileComponent);
        componentsEligibleForBestValue.forEach(component -> {
            for (MetricDtoWithBestValue metricWithBestValue : metricDtosWithBestValueMeasure) {
                if (measuresByComponentUuidAndMetric.get((Object)component.uuid(), (Object)metricWithBestValue.getMetric()) != null) continue;
                measuresByComponentUuidAndMetric.put((Object)component.uuid(), (Object)metricWithBestValue.getMetric(), (Object)ComponentTreeData.Measure.createFromMeasureDto(metricWithBestValue.getBestValue()));
            }
        });
    }

    private static List<ComponentDto> filterComponents(List<ComponentDto> components, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric, List<MetricDto> metrics, ComponentTreeRequest wsRequest) {
        if (!ComponentTreeAction.componentWithMeasuresOnly(wsRequest)) {
            return components;
        }
        String metricKeyToSort = wsRequest.getMetricSort();
        Optional<MetricDto> metricToSort = metrics.stream().filter(m -> metricKeyToSort.equals(m.getKey())).findFirst();
        Preconditions.checkState((boolean)metricToSort.isPresent(), (String)"Metric '%s' not found", (Object[])new Object[]{metricKeyToSort, wsRequest.getMetricKeys()});
        return (List)components.stream().filter(new HasMeasure(measuresByComponentUuidAndMetric, metricToSort.get(), wsRequest.getMetricPeriodSort())).collect(MoreCollectors.toList((int)components.size()));
    }

    private static boolean componentWithMeasuresOnly(ComponentTreeRequest wsRequest) {
        return WITH_MEASURES_ONLY_METRIC_SORT_FILTER.equals(wsRequest.getMetricSortFilter());
    }

    private static List<ComponentDto> sortComponents(List<ComponentDto> components, ComponentTreeRequest wsRequest, List<MetricDto> metrics, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric) {
        return ComponentTreeSort.sortComponents(components, wsRequest, metrics, measuresByComponentUuidAndMetric);
    }

    private static List<ComponentDto> paginateComponents(List<ComponentDto> components, ComponentTreeRequest wsRequest) {
        return (List)components.stream().skip(Paging.offset((int)wsRequest.getPage(), (int)wsRequest.getPageSize())).limit(wsRequest.getPageSize().intValue()).collect(MoreCollectors.toList((int)wsRequest.getPageSize()));
    }

    @CheckForNull
    private List<String> childrenQualifiers(ComponentTreeRequest request, String baseQualifier) {
        List<String> requestQualifiers = request.getQualifiers();
        List childrenQualifiers = null;
        if (LEAVES_STRATEGY.equals(request.getStrategy())) {
            childrenQualifiers = this.resourceTypes.getLeavesQualifiers(baseQualifier);
        }
        if (requestQualifiers == null) {
            return childrenQualifiers;
        }
        if (childrenQualifiers == null) {
            return requestQualifiers;
        }
        Sets.SetView qualifiersIntersection = Sets.intersection(new HashSet(childrenQualifiers), new HashSet<String>(requestQualifiers));
        return new ArrayList<String>((Collection<String>)qualifiersIntersection);
    }

    private ComponentTreeQuery toComponentTreeQuery(ComponentTreeRequest wsRequest, ComponentDto baseComponent) {
        List<String> childrenQualifiers = this.childrenQualifiers(wsRequest, baseComponent.qualifier());
        ComponentTreeQuery.Builder componentTreeQueryBuilder = ComponentTreeQuery.builder().setBaseUuid(baseComponent.uuid()).setStrategy(STRATEGIES.get(wsRequest.getStrategy()));
        if (wsRequest.getQuery() != null) {
            componentTreeQueryBuilder.setNameOrKeyQuery(wsRequest.getQuery());
        }
        if (childrenQualifiers != null) {
            componentTreeQueryBuilder.setQualifiers(childrenQualifiers);
        }
        return componentTreeQueryBuilder.build();
    }

    private void checkPermissions(ComponentDto baseComponent) {
        this.userSession.checkComponentPermission("user", baseComponent);
    }

    public static boolean isFileComponent(@Nonnull ComponentDto input) {
        return QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE.contains(input.qualifier());
    }

    private static /* synthetic */ void lambda$searchMeasuresByComponentUuidAndMetric$2(Table measuresByComponentUuidAndMetric, Map metricsById, ResultContext result) {
        LiveMeasureDto measureDto = (LiveMeasureDto)result.getResultObject();
        measuresByComponentUuidAndMetric.put((Object)measureDto.getComponentUuid(), (Object)((MetricDto)metricsById.get(measureDto.getMetricId())), (Object)ComponentTreeData.Measure.createFromMeasureDto(measureDto));
    }

    private static class MetricDtoToMetricDtoWithBestValue
    implements Function<MetricDto, MetricDtoWithBestValue> {
        private MetricDtoToMetricDtoWithBestValue() {
        }

        @Override
        public MetricDtoWithBestValue apply(@Nonnull MetricDto input) {
            return new MetricDtoWithBestValue(input);
        }
    }
}

