/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonarqube.ws.Measures;

class ComponentTreeData {
    private final ComponentDto baseComponent;
    private final List<ComponentDto> components;
    private final int componentCount;
    private final Map<String, ComponentDto> referenceComponentsByUuid;
    private final List<MetricDto> metrics;
    private final Measures.Period period;
    private final Table<String, MetricDto, Measure> measuresByComponentUuidAndMetric;

    private ComponentTreeData(Builder builder) {
        this.baseComponent = builder.baseComponent;
        this.components = builder.componentsFromDb;
        this.componentCount = builder.componentCount;
        this.referenceComponentsByUuid = builder.referenceComponentsByUuid;
        this.metrics = builder.metrics;
        this.measuresByComponentUuidAndMetric = builder.measuresByComponentUuidAndMetric;
        this.period = builder.period;
    }

    public ComponentDto getBaseComponent() {
        return this.baseComponent;
    }

    @CheckForNull
    List<ComponentDto> getComponents() {
        return this.components;
    }

    @CheckForNull
    int getComponentCount() {
        return this.componentCount;
    }

    @CheckForNull
    public Map<String, ComponentDto> getReferenceComponentsByUuid() {
        return this.referenceComponentsByUuid;
    }

    @CheckForNull
    List<MetricDto> getMetrics() {
        return this.metrics;
    }

    @CheckForNull
    Measures.Period getPeriod() {
        return this.period;
    }

    @CheckForNull
    Table<String, MetricDto, Measure> getMeasuresByComponentUuidAndMetric() {
        return this.measuresByComponentUuidAndMetric;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Measure {
        private double value;
        private String data;
        private double variation;

        public Measure(@Nullable String data, @Nullable Double value, @Nullable Double variation) {
            this.data = data;
            this.value = Measure.toPrimitive(value);
            this.variation = Measure.toPrimitive(variation);
        }

        private Measure(LiveMeasureDto measureDto) {
            this(measureDto.getDataAsString(), measureDto.getValue(), measureDto.getVariation());
        }

        public double getValue() {
            return this.value;
        }

        public boolean isValueSet() {
            return !Double.isNaN(this.value);
        }

        @CheckForNull
        public String getData() {
            return this.data;
        }

        public double getVariation() {
            return this.variation;
        }

        public boolean isVariationSet() {
            return !Double.isNaN(this.variation);
        }

        static Measure createFromMeasureDto(LiveMeasureDto measureDto) {
            return new Measure(measureDto);
        }

        private static double toPrimitive(@Nullable Double value) {
            return value == null ? Double.NaN : value;
        }
    }

    static class Builder {
        private ComponentDto baseComponent;
        private List<ComponentDto> componentsFromDb;
        private Map<String, ComponentDto> referenceComponentsByUuid;
        private int componentCount;
        private List<MetricDto> metrics;
        private Measures.Period period;
        private Table<String, MetricDto, Measure> measuresByComponentUuidAndMetric;

        private Builder() {
        }

        public Builder setBaseComponent(ComponentDto baseComponent) {
            this.baseComponent = baseComponent;
            return this;
        }

        public Builder setComponentsFromDb(List<ComponentDto> componentsFromDbQuery) {
            this.componentsFromDb = componentsFromDbQuery;
            return this;
        }

        public Builder setComponentCount(int componentCount) {
            this.componentCount = componentCount;
            return this;
        }

        public Builder setMetrics(List<MetricDto> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder setPeriod(@Nullable Measures.Period period) {
            this.period = period;
            return this;
        }

        public Builder setMeasuresByComponentUuidAndMetric(Table<String, MetricDto, Measure> measuresByComponentUuidAndMetric) {
            this.measuresByComponentUuidAndMetric = measuresByComponentUuidAndMetric;
            return this;
        }

        public Builder setReferenceComponentsByUuid(Map<String, ComponentDto> referenceComponentsByUuid) {
            this.referenceComponentsByUuid = referenceComponentsByUuid;
            return this;
        }

        public ComponentTreeData build() {
            Objects.requireNonNull(this.baseComponent);
            return new ComponentTreeData(this);
        }
    }
}

