/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import java.util.Optional;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureValueFormatter;
import org.sonarqube.ws.Common;

class MetricDtoToWsMetric {
    private MetricDtoToWsMetric() {
    }

    static Common.Metric metricDtoToWsMetric(MetricDto metricDto) {
        Common.Metric.Builder metric = Common.Metric.newBuilder();
        metric.setKey(metricDto.getKey());
        metric.setType(metricDto.getValueType());
        metric.setName(metricDto.getShortName());
        Optional.ofNullable(metricDto.getDescription()).ifPresent(arg_0 -> ((Common.Metric.Builder)metric).setDescription(arg_0));
        Optional.ofNullable(metricDto.getDomain()).ifPresent(arg_0 -> ((Common.Metric.Builder)metric).setDomain(arg_0));
        if (metricDto.getDirection() != 0) {
            metric.setHigherValuesAreBetter(metricDto.getDirection() > 0);
        }
        metric.setQualitative(metricDto.isQualitative());
        metric.setHidden(metricDto.isHidden());
        metric.setCustom(metricDto.isUserManaged());
        Optional.ofNullable(metricDto.getDecimalScale()).ifPresent(arg_0 -> ((Common.Metric.Builder)metric).setDecimalScale(arg_0));
        Optional.ofNullable(metricDto.getBestValue()).ifPresent(bv -> metric.setBestValue(MeasureValueFormatter.formatNumericalValue(bv, metricDto)));
        Optional.ofNullable(metricDto.getWorstValue()).ifPresent(wv -> metric.setWorstValue(MeasureValueFormatter.formatNumericalValue(wv, metricDto)));
        return metric.build();
    }
}

