/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.notification.NotificationDispatcherMetadata;

public class NotificationCenter {
    private static final Logger LOG = Loggers.get(NotificationCenter.class);
    private final NotificationDispatcherMetadata[] dispatchersMetadata;
    private final NotificationChannel[] channels;

    public NotificationCenter(NotificationDispatcherMetadata[] metadata, NotificationChannel[] channels) {
        this.dispatchersMetadata = metadata;
        this.channels = channels;
    }

    public NotificationCenter(NotificationDispatcherMetadata[] metadata) {
        this(metadata, new NotificationChannel[0]);
        LOG.warn("There is no notification channel - no notification will be delivered!");
    }

    public NotificationCenter(NotificationChannel[] channels) {
        this(new NotificationDispatcherMetadata[0], channels);
    }

    public NotificationCenter() {
        this(new NotificationDispatcherMetadata[0], new NotificationChannel[0]);
        LOG.warn("There is no notification channel - no notification will be delivered!");
    }

    public List<NotificationChannel> getChannels() {
        return Arrays.asList(this.channels);
    }

    public List<String> getDispatcherKeysForProperty(String propertyKey, @Nullable String propertyValue) {
        ImmutableList.Builder keys = ImmutableList.builder();
        for (NotificationDispatcherMetadata metadata : this.dispatchersMetadata) {
            String dispatcherKey = metadata.getDispatcherKey();
            String value = metadata.getProperty(propertyKey);
            if (value == null || propertyValue != null && !value.equals(propertyValue)) continue;
            keys.add((Object)dispatcherKey);
        }
        return keys.build();
    }
}

