/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.ws;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.ProcessProperties;
import org.sonar.server.notification.NotificationCenter;
import org.sonar.server.notification.ws.Dispatchers;

public class DispatchersImpl
implements Dispatchers,
Startable {
    private static final Set<String> GLOBAL_DISPATCHERS_TO_IGNORE_ON_SONAR_CLOUD = ImmutableSet.of((Object)"NewAlerts");
    private final NotificationCenter notificationCenter;
    private final Configuration configuration;
    private List<String> projectDispatchers;
    private List<String> globalDispatchers;

    public DispatchersImpl(NotificationCenter notificationCenter, Configuration configuration) {
        this.notificationCenter = notificationCenter;
        this.configuration = configuration;
    }

    @Override
    public List<String> getGlobalDispatchers() {
        return this.globalDispatchers;
    }

    @Override
    public List<String> getProjectDispatchers() {
        return this.projectDispatchers;
    }

    public void start() {
        boolean isOnSonarCloud = this.configuration.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
        this.globalDispatchers = (List)this.notificationCenter.getDispatcherKeysForProperty("globalNotification", "true").stream().filter(DispatchersImpl.filterDispatcherForSonarCloud(isOnSonarCloud)).sorted().collect(MoreCollectors.toList());
        this.projectDispatchers = (List)this.notificationCenter.getDispatcherKeysForProperty("perProjectNotification", "true").stream().sorted().collect(MoreCollectors.toList());
    }

    private static Predicate<String> filterDispatcherForSonarCloud(boolean isOnSonarCloud) {
        return dispatcher -> !isOnSonarCloud || !GLOBAL_DISPATCHERS_TO_IGNORE_ON_SONAR_CLOUD.contains(dispatcher);
    }

    public void stop() {
    }
}

