/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.security.SecurityRealm;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.user.SecurityRealmFactory;

@ServerSide
public class GlobalSystemSection
implements SystemInfoSection,
Global {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final Configuration config;
    private final Server server;
    private final SecurityRealmFactory securityRealmFactory;
    private final IdentityProviderRepository identityProviderRepository;

    public GlobalSystemSection(Configuration config, Server server, SecurityRealmFactory securityRealmFactory, IdentityProviderRepository identityProviderRepository) {
        this.config = config;
        this.server = server;
        this.securityRealmFactory = securityRealmFactory;
        this.identityProviderRepository = identityProviderRepository;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("System");
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Server ID", (String)this.server.getId());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"High Availability", (Boolean)true);
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"External User Authentication", (String)this.getExternalUserAuthentication());
        GlobalSystemSection.addIfNotEmpty(protobuf, "Accepted external identity providers", this.getEnabledIdentityProviders());
        GlobalSystemSection.addIfNotEmpty(protobuf, "External identity providers whose users are allowed to sign themselves up", this.getAllowsToSignUpEnabledIdentityProviders());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Force authentication", (Boolean)this.getForceAuthentication());
        return protobuf.build();
    }

    private List<String> getEnabledIdentityProviders() {
        return (List)this.identityProviderRepository.getAllEnabledAndSorted().stream().filter(IdentityProvider::isEnabled).map(IdentityProvider::getName).collect(MoreCollectors.toList());
    }

    private List<String> getAllowsToSignUpEnabledIdentityProviders() {
        return (List)this.identityProviderRepository.getAllEnabledAndSorted().stream().filter(IdentityProvider::isEnabled).filter(IdentityProvider::allowsUsersToSignUp).map(IdentityProvider::getName).collect(MoreCollectors.toList());
    }

    private boolean getForceAuthentication() {
        return this.config.getBoolean("sonar.forceAuthentication").orElse(false);
    }

    private static void addIfNotEmpty(ProtobufSystemInfo.Section.Builder protobuf, String key, @Nullable List<String> values) {
        if (values != null && !values.isEmpty()) {
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)key, (String)COMMA_JOINER.join(values));
        }
    }

    @CheckForNull
    private String getExternalUserAuthentication() {
        SecurityRealm realm = this.securityRealmFactory.getRealm();
        return realm == null ? null : realm.getName();
    }
}

