/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Optional;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.app.RestartFlagHolder;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.db.migration.DatabaseMigrationState;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.System;

public class StatusAction
implements SystemWsAction {
    private final Server server;
    private final DatabaseMigrationState migrationState;
    private final Platform platform;
    private final RestartFlagHolder restartFlagHolder;

    public StatusAction(Server server, DatabaseMigrationState migrationState, Platform platform, RestartFlagHolder restartFlagHolder) {
        this.server = server;
        this.migrationState = migrationState;
        this.platform = platform;
        this.restartFlagHolder = restartFlagHolder;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("status").setDescription("Get state information about SonarQube.<p>status: the running status <ul> <li>STARTING: SonarQube Web Server is up and serving some Web Services (eg. api/system/status) but initialization is still ongoing</li> <li>UP: SonarQube instance is up and running</li> <li>DOWN: SonarQube instance is up but not running because migration has failed (refer to WS /api/system/migrate_db for details) or some other reason (check logs).</li> <li>RESTARTING: SonarQube instance is still up but a restart has been requested (refer to WS /api/system/restart for details).</li> <li>DB_MIGRATION_NEEDED: database migration is required. DB migration can be started using WS /api/system/migrate_db.</li> <li>DB_MIGRATION_RUNNING: DB migration is running (refer to WS /api/system/migrate_db for details)</li> </ul></p>").setSince("5.2").setResponseExample(Resources.getResource(this.getClass(), (String)"example-status.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        System.StatusResponse.Builder protobuf = System.StatusResponse.newBuilder();
        Optional.ofNullable(this.server.getId()).ifPresent(arg_0 -> ((System.StatusResponse.Builder)protobuf).setId(arg_0));
        Optional.ofNullable(this.server.getVersion()).ifPresent(arg_0 -> ((System.StatusResponse.Builder)protobuf).setVersion(arg_0));
        protobuf.setStatus(this.computeStatus());
        WsUtils.writeProtobuf((Message)protobuf.build(), request, response);
    }

    private System.Status computeStatus() {
        Platform.Status platformStatus = this.platform.status();
        switch (platformStatus) {
            case BOOTING: {
                return System.Status.DOWN;
            }
            case UP: {
                return this.restartFlagHolder.isRestarting() ? System.Status.RESTARTING : System.Status.UP;
            }
            case STARTING: {
                return this.computeStatusInStarting();
            }
            case SAFEMODE: {
                return this.computeStatusInSafemode();
            }
        }
        throw new IllegalArgumentException("Unsupported Platform.Status " + (Object)((Object)platformStatus));
    }

    private System.Status computeStatusInStarting() {
        DatabaseMigrationState.Status databaseMigrationStatus = this.migrationState.getStatus();
        switch (databaseMigrationStatus) {
            case NONE: {
                return System.Status.STARTING;
            }
            case RUNNING: {
                return System.Status.DB_MIGRATION_RUNNING;
            }
            case FAILED: {
                return System.Status.DOWN;
            }
            case SUCCEEDED: {
                return System.Status.STARTING;
            }
        }
        throw new IllegalArgumentException("Unsupported DatabaseMigration.Status " + databaseMigrationStatus);
    }

    private System.Status computeStatusInSafemode() {
        DatabaseMigrationState.Status databaseMigrationStatus = this.migrationState.getStatus();
        switch (databaseMigrationStatus) {
            case NONE: {
                return System.Status.DB_MIGRATION_NEEDED;
            }
            case RUNNING: {
                return System.Status.DB_MIGRATION_RUNNING;
            }
            case FAILED: {
                return System.Status.DOWN;
            }
            case SUCCEEDED: {
                return System.Status.STARTING;
            }
        }
        throw new IllegalArgumentException("Unsupported DatabaseMigration.Status " + databaseMigrationStatus);
    }
}

