/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.util.FileUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.platform.ServerFileSystem;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.ws.WsUtils;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.Version;

public class PluginDownloader
implements Startable {
    private static final Logger LOG = Loggers.get(PluginDownloader.class);
    private static final String TMP_SUFFIX = "tmp";
    private static final String PLUGIN_EXTENSION = "jar";
    private final UpdateCenterMatrixFactory updateCenterMatrixFactory;
    private final HttpDownloader downloader;
    private final File downloadDir;

    public PluginDownloader(UpdateCenterMatrixFactory updateCenterMatrixFactory, HttpDownloader downloader, ServerFileSystem fileSystem) {
        this.updateCenterMatrixFactory = updateCenterMatrixFactory;
        this.downloader = downloader;
        this.downloadDir = fileSystem.getDownloadedPluginsDir();
    }

    public void start() {
        try {
            org.apache.commons.io.FileUtils.forceMkdir((File)this.downloadDir);
            for (File tempFile : PluginDownloader.listTempFile(this.downloadDir)) {
                FileUtils.deleteQuietly((File)tempFile);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create the directory: " + this.downloadDir, e);
        }
    }

    public void stop() {
    }

    public void cancelDownloads() {
        try {
            if (this.downloadDir.exists()) {
                FileUtils.cleanDirectory((File)this.downloadDir);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to clean the plugin downloads directory: " + this.downloadDir, e);
        }
    }

    public List<String> getDownloadedPluginFilenames() {
        ArrayList<String> names = new ArrayList<String>();
        for (File file : PluginDownloader.listPlugins(this.downloadDir)) {
            names.add(file.getName());
        }
        return names;
    }

    public Collection<PluginInfo> getDownloadedPlugins() {
        return (Collection)PluginDownloader.listPlugins(this.downloadDir).stream().map(PluginInfo::create).collect(MoreCollectors.toList());
    }

    public void download(String pluginKey, Version version) {
        Optional<UpdateCenter> updateCenter = this.updateCenterMatrixFactory.getUpdateCenter(true);
        if (updateCenter.isPresent()) {
            List installablePlugins = ((UpdateCenter)updateCenter.get()).findInstallablePlugins(pluginKey, version);
            WsUtils.checkRequest(!installablePlugins.isEmpty(), "Error while downloading plugin '%s' with version '%s'. No compatible plugin found.", pluginKey, version.getName());
            for (Release release : installablePlugins) {
                try {
                    this.downloadRelease(release);
                }
                catch (Exception e) {
                    String message = String.format("Fail to download the plugin (%s, version %s) from %s (error is : %s)", release.getArtifact().getKey(), release.getVersion().getName(), release.getDownloadUrl(), e.getMessage());
                    LOG.debug(message, (Object)e);
                    throw new IllegalStateException(message, e);
                }
            }
        }
    }

    private void downloadRelease(Release release) throws URISyntaxException, IOException {
        String url = release.getDownloadUrl();
        URI uri = new URI(url);
        if (url.startsWith("file:")) {
            File file = org.apache.commons.io.FileUtils.toFile((URL)uri.toURL());
            org.apache.commons.io.FileUtils.copyFileToDirectory((File)file, (File)this.downloadDir);
        } else {
            String filename = StringUtils.substringAfterLast((String)uri.getPath(), (String)"/");
            if (!filename.endsWith(".jar")) {
                filename = release.getKey() + "-" + release.getVersion() + "." + PLUGIN_EXTENSION;
            }
            File targetFile = new File(this.downloadDir, filename);
            File tempFile = new File(this.downloadDir, filename + "." + TMP_SUFFIX);
            this.downloader.download(uri, tempFile);
            org.apache.commons.io.FileUtils.copyFile((File)tempFile, (File)targetFile);
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private static Collection<File> listTempFile(File dir) {
        return org.apache.commons.io.FileUtils.listFiles((File)dir, (String[])new String[]{TMP_SUFFIX}, (boolean)false);
    }

    private static Collection<File> listPlugins(File dir) {
        return org.apache.commons.io.FileUtils.listFiles((File)dir, (String[])new String[]{PLUGIN_EXTENSION}, (boolean)false);
    }
}

