/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.base.Optional;
import java.util.Objects;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.plugins.PluginDownloader;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.edition.EditionBundledPlugins;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.updatecenter.common.PluginUpdate;
import org.sonar.updatecenter.common.UpdateCenter;

public class InstallAction
implements PluginsWsAction {
    private static final String PARAM_KEY = "key";
    private final UpdateCenterMatrixFactory updateCenterFactory;
    private final PluginDownloader pluginDownloader;
    private final UserSession userSession;

    public InstallAction(UpdateCenterMatrixFactory updateCenterFactory, PluginDownloader pluginDownloader, UserSession userSession) {
        this.updateCenterFactory = updateCenterFactory;
        this.pluginDownloader = pluginDownloader;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("install").setPost(true).setSince("5.2").setDescription("Installs the latest version of a plugin specified by its key.<br/>Plugin information is retrieved from Update Center.<br/>Requires user to be authenticated with Administer System permissions").setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setDescription("The key identifying the plugin to install");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        String key = request.mandatoryParam(PARAM_KEY);
        PluginUpdate pluginUpdate = this.findAvailablePluginByKey(key);
        this.pluginDownloader.download(key, pluginUpdate.getRelease().getVersion());
        response.noContent();
    }

    private PluginUpdate findAvailablePluginByKey(String key) {
        PluginUpdate pluginUpdate = null;
        Optional<UpdateCenter> updateCenter = this.updateCenterFactory.getUpdateCenter(false);
        if (updateCenter.isPresent()) {
            pluginUpdate = ((UpdateCenter)updateCenter.get()).findAvailablePlugins().stream().filter(Objects::nonNull).filter(u -> key.equals(u.getPlugin().getKey())).findFirst().orElse(null);
        }
        if (pluginUpdate == null) {
            throw new IllegalArgumentException(String.format("No plugin with key '%s' or plugin '%s' is already installed in latest version", key, key));
        }
        if (EditionBundledPlugins.isEditionBundled(pluginUpdate.getPlugin())) {
            throw new IllegalArgumentException(String.format("SonarSource commercial plugin with key '%s' can only be installed as part of a SonarSource edition", pluginUpdate.getPlugin().getKey()));
        }
        return pluginUpdate;
    }
}

