/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class ProjectsWsSupport {
    public static final String PARAM_ORGANIZATION = "organization";
    private final DbClient dbClient;
    private final DefaultOrganizationProvider organizationProvider;
    private final BillingValidationsProxy billingValidations;

    public ProjectsWsSupport(DbClient dbClient, DefaultOrganizationProvider organizationProvider, BillingValidationsProxy billingValidations) {
        this.dbClient = dbClient;
        this.organizationProvider = organizationProvider;
        this.billingValidations = billingValidations;
    }

    void addOrganizationParam(WebService.NewAction action) {
        action.createParam(PARAM_ORGANIZATION).setDescription("The key of the organization").setRequired(false).setInternal(true).setSince("6.3");
    }

    OrganizationDto getOrganization(DbSession dbSession, @Nullable String organizationKeyParam) {
        String organizationKey = organizationKeyParam == null ? this.organizationProvider.get().getKey() : organizationKeyParam;
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization for key '%s'", organizationKey);
    }

    void checkCanUpdateProjectsVisibility(OrganizationDto organizationDto, boolean newProjectsPrivate) {
        try {
            BillingValidations.Organization organization = new BillingValidations.Organization(organizationDto.getKey(), organizationDto.getUuid(), organizationDto.getName());
            this.billingValidations.checkCanUpdateProjectVisibility(organization, newProjectsPrivate);
        }
        catch (BillingValidations.BillingValidationsException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

