/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ProjectLinkDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureDto;

class SearchMyProjectsData {
    private final List<ComponentDto> projects;
    private final ListMultimap<String, ProjectLinkDto> projectLinksByProjectUuid;
    private final Map<String, SnapshotDto> snapshotsByComponentUuid;
    private final Map<String, String> qualityGateStatuses;
    private final int totalNbOfProject;

    private SearchMyProjectsData(Builder builder) {
        this.projects = ImmutableList.copyOf((Collection)builder.projects);
        this.projectLinksByProjectUuid = SearchMyProjectsData.buildProjectLinks(builder.projectLinks);
        this.snapshotsByComponentUuid = (Map)builder.snapshots.stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getComponentUuid, Function.identity()));
        this.qualityGateStatuses = SearchMyProjectsData.buildQualityGateStatuses(builder.qualityGates);
        this.totalNbOfProject = builder.totalNbOfProjects;
    }

    static Builder builder() {
        return new Builder();
    }

    List<ComponentDto> projects() {
        return this.projects;
    }

    List<ProjectLinkDto> projectLinksFor(String projectUuid) {
        return this.projectLinksByProjectUuid.get((Object)projectUuid);
    }

    Optional<SnapshotDto> lastSnapshot(String componentUuid) {
        return Optional.ofNullable(this.snapshotsByComponentUuid.get(componentUuid));
    }

    Optional<String> qualityGateStatusFor(String componentUuid) {
        return Optional.ofNullable(this.qualityGateStatuses.get(componentUuid));
    }

    int totalNbOfProjects() {
        return this.totalNbOfProject;
    }

    private static ListMultimap<String, ProjectLinkDto> buildProjectLinks(List<ProjectLinkDto> dtos) {
        ImmutableListMultimap.Builder projectLinks = ImmutableListMultimap.builder();
        dtos.forEach(projectLink -> projectLinks.put((Object)projectLink.getProjectUuid(), projectLink));
        return projectLinks.build();
    }

    private static Map<String, String> buildQualityGateStatuses(List<LiveMeasureDto> measures) {
        return ImmutableMap.copyOf(measures.stream().collect(Collectors.toMap(LiveMeasureDto::getComponentUuid, LiveMeasureDto::getDataAsString)));
    }

    static class Builder {
        private List<ComponentDto> projects;
        private List<ProjectLinkDto> projectLinks;
        private List<SnapshotDto> snapshots;
        private List<LiveMeasureDto> qualityGates;
        private Integer totalNbOfProjects;

        private Builder() {
        }

        Builder setProjects(List<ComponentDto> projects) {
            this.projects = projects;
            return this;
        }

        public Builder setProjectLinks(List<ProjectLinkDto> projectLinks) {
            this.projectLinks = projectLinks;
            return this;
        }

        public Builder setSnapshots(List<SnapshotDto> snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public Builder setQualityGates(List<LiveMeasureDto> qGateStatuses) {
            this.qualityGates = qGateStatuses;
            return this;
        }

        public Builder setTotalNbOfProjects(Integer totalNbOfProjects) {
            this.totalNbOfProjects = totalNbOfProjects;
            return this;
        }

        SearchMyProjectsData build() {
            Objects.requireNonNull(this.projects);
            Objects.requireNonNull(this.projectLinks);
            Objects.requireNonNull(this.snapshots);
            Objects.requireNonNull(this.qualityGates);
            Objects.requireNonNull(this.totalNbOfProjects);
            return new SearchMyProjectsData(this);
        }
    }
}

