/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.projectanalysis.ws.EventCategory;

class SearchRequest {
    static final int DEFAULT_PAGE_SIZE = 100;
    static final int MAX_SIZE = 500;
    private final String project;
    private final String branch;
    private final String pullRequest;
    private final EventCategory category;
    private final int page;
    private final int pageSize;
    private final String from;
    private final String to;

    private SearchRequest(Builder builder) {
        this.project = builder.project;
        this.branch = builder.branch;
        this.pullRequest = builder.pullRequest;
        this.category = builder.category;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.from = builder.from;
        this.to = builder.to;
    }

    public String getProject() {
        return this.project;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    @CheckForNull
    public String getPullRequest() {
        return this.pullRequest;
    }

    @CheckForNull
    public EventCategory getCategory() {
        return this.category;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @CheckForNull
    public String getFrom() {
        return this.from;
    }

    @CheckForNull
    public String getTo() {
        return this.to;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String project;
        private String branch;
        private String pullRequest;
        private EventCategory category;
        private int page = 1;
        private int pageSize = 100;
        private String from;
        private String to;

        private Builder() {
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public Builder setCategory(@Nullable EventCategory category) {
            this.category = category;
            return this;
        }

        public Builder setPage(int page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setFrom(@Nullable String from) {
            this.from = from;
            return this;
        }

        public Builder setTo(@Nullable String to) {
            this.to = to;
            return this;
        }

        public SearchRequest build() {
            Objects.requireNonNull(this.project, "Project is required");
            Preconditions.checkArgument((this.pageSize <= 500 ? 1 : 0) != 0, (Object)"Page size must be lower than or equal to 500");
            return new SearchRequest(this);
        }
    }
}

