/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class CreateConditionAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final QualityGatesWsSupport wsSupport;

    public CreateConditionAction(DbClient dbClient, QualityGateConditionsUpdater qualityGateConditionsUpdater, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("create_condition").setPost(true).setDescription("Add a new condition to a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setResponseExample(this.getClass().getResource("create-condition-example.json")).setChangelog(new Change[]{new Change("7.6", "Removed optional 'warning' and 'period' parameters"), new Change("7.6", "Made 'error' parameter mandatory"), new Change("7.6", "Reduced the possible values of 'op' parameter to LT and GT")}).setHandler((RequestHandler)this);
        createCondition.createParam("gateId").setRequired(true).setDescription("ID of the quality gate").setExampleValue((Object)"1");
        QualityGatesWs.addConditionParams(createCondition);
        this.wsSupport.createOrganizationParam(createCondition);
    }

    public void handle(Request request, Response response) {
        int gateId = request.mandatoryParamAsInt("gateId");
        String metric = request.mandatoryParam("metric");
        String operator = request.mandatoryParam("op");
        String error = request.mandatoryParam("error");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QGateWithOrgDto qualityGate = this.wsSupport.getByOrganizationAndId(dbSession, organization, gateId);
            this.wsSupport.checkCanEdit(qualityGate);
            QualityGateConditionDto condition = this.qualityGateConditionsUpdater.createCondition(dbSession, (QualityGateDto)qualityGate, metric, operator, error);
            Qualitygates.CreateConditionResponse.Builder createConditionResponse = Qualitygates.CreateConditionResponse.newBuilder().setId(condition.getId()).setMetric(condition.getMetricKey()).setError(condition.getErrorThreshold()).setOp(condition.getOperator());
            WsUtils.writeProtobuf((Message)createConditionResponse.build(), request, response);
            dbSession.commit();
        }
    }
}

