/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.BulkChangeResult;
import org.sonar.server.qualityprofile.QProfileRules;
import org.sonar.server.qualityprofile.ws.BulkChangeWsResponse;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.rule.index.RuleQuery;
import org.sonar.server.rule.ws.RuleQueryFactory;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.user.UserSession;

public class DeactivateRulesAction
implements QProfileWsAction {
    private final RuleQueryFactory ruleQueryFactory;
    private final UserSession userSession;
    private final QProfileRules ruleActivator;
    private final QProfileWsSupport wsSupport;
    private final DbClient dbClient;

    public DeactivateRulesAction(RuleQueryFactory ruleQueryFactory, UserSession userSession, QProfileRules ruleActivator, QProfileWsSupport wsSupport, DbClient dbClient) {
        this.ruleQueryFactory = ruleQueryFactory;
        this.userSession = userSession;
        this.ruleActivator = ruleActivator;
        this.wsSupport = wsSupport;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction deactivate = controller.createAction("deactivate_rules").setDescription("Bulk deactivate rules on Quality profiles.<br>Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setPost(true).setSince("4.4").setHandler((RequestHandler)this);
        RuleWsSupport.defineGenericRuleSearchParameters(deactivate);
        deactivate.createParam("targetKey").setDescription("Quality Profile key on which the rule deactivation is done. To retrieve a profile key please see <code>api/qualityprofiles/search</code>").setDeprecatedKey("profile_key", "6.5").setRequired(true).setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL1");
    }

    public void handle(Request request, Response response) throws Exception {
        BulkChangeResult result;
        String qualityProfileKey = request.mandatoryParam("targetKey");
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.wsSupport.getProfile(dbSession, QProfileReference.fromKey(qualityProfileKey));
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, profile);
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            RuleQuery ruleQuery = this.ruleQueryFactory.createRuleQuery(dbSession, request);
            ruleQuery.setIncludeExternal(false);
            result = this.ruleActivator.bulkDeactivateAndCommit(dbSession, profile, ruleQuery);
        }
        BulkChangeWsResponse.writeResponse(result, response);
    }
}

