/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.Facets;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.rule.index.RuleQuery;
import org.sonar.server.rule.ws.ActiveRuleCompleter;
import org.sonar.server.rule.ws.RuleMapper;
import org.sonar.server.rule.ws.RuleQueryFactory;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.rule.ws.RulesWsParameters;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Rules;

public class SearchAction
implements RulesWsAction {
    public static final String ACTION = "search";
    private static final Collection<String> DEFAULT_FACETS = ImmutableSet.of((Object)"languages", (Object)"repositories", (Object)"tags");
    private static final String[] POSSIBLE_FACETS = new String[]{"languages", "repositories", "tags", "severities", "active_severities", "statuses", "types", "true", "cwe", "owaspTop10", "sansTop25", "sonarsourceSecurity"};
    private final RuleQueryFactory ruleQueryFactory;
    private final DbClient dbClient;
    private final RuleIndex ruleIndex;
    private final ActiveRuleCompleter activeRuleCompleter;
    private final RuleMapper mapper;
    private final RuleWsSupport ruleWsSupport;

    public SearchAction(RuleIndex ruleIndex, ActiveRuleCompleter activeRuleCompleter, RuleQueryFactory ruleQueryFactory, DbClient dbClient, RuleMapper mapper, RuleWsSupport ruleWsSupport) {
        this.ruleIndex = ruleIndex;
        this.activeRuleCompleter = activeRuleCompleter;
        this.ruleQueryFactory = ruleQueryFactory;
        this.dbClient = dbClient;
        this.mapper = mapper;
        this.ruleWsSupport = ruleWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction(ACTION).addPagingParams(100, 500).setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("7.1", "The field 'scope' has been added to the response")}).setChangelog(new Change[]{new Change("7.1", "The field 'scope' has been added to the 'f' parameter")}).setChangelog(new Change[]{new Change("7.2", "The field 'isExternal' has been added to the response")}).setChangelog(new Change[]{new Change("7.2", "The field 'includeExternal' has been added to the 'f' parameter")}).setChangelog(new Change[]{new Change("7.5", "The field 'updatedAt' has been added to the 'f' parameter")});
        action.createParam("facets").setDescription("Comma-separated list of the facets to be computed. No facet is computed by default.").setPossibleValues((Object[])POSSIBLE_FACETS).setExampleValue((Object)String.format("%s,%s", POSSIBLE_FACETS[0], POSSIBLE_FACETS[1]));
        WebService.NewParam paramFields = action.createParam("f").setDescription("Comma-separated list of the fields to be returned in response. All the fields are returned by default, except actives.Since 5.5, following fields have been deprecated :<ul><li>\"defaultDebtRemFn\" becomes \"defaultRemFn\"</li><li>\"debtRemFn\" becomes \"remFn\"</li><li>\"effortToFixDescription\" becomes \"gapDescription\"</li><li>\"debtOverloaded\" becomes \"remFnOverloaded\"</li></ul>").setPossibleValues((Collection)Ordering.natural().sortedCopy(RulesWsParameters.OPTIONAL_FIELDS));
        Iterator<String> it = RulesWsParameters.OPTIONAL_FIELDS.iterator();
        paramFields.setExampleValue((Object)String.format("%s,%s", it.next(), it.next()));
        action.setDescription("Search for a collection of relevant rules matching a specified query.<br/>Since 5.5, following fields in the response have been deprecated :<ul><li>\"effortToFixDescription\" becomes \"gapDescription\"</li><li>\"debtRemFnCoeff\" becomes \"remFnGapMultiplier\"</li><li>\"defaultDebtRemFnCoeff\" becomes \"defaultRemFnGapMultiplier\"</li><li>\"debtRemFnOffset\" becomes \"remFnBaseEffort\"</li><li>\"defaultDebtRemFnOffset\" becomes \"defaultRemFnBaseEffort\"</li><li>\"debtOverloaded\" becomes \"remFnOverloaded\"</li></ul>").setResponseExample(this.getClass().getResource("search-example.json")).setSince("4.4").setHandler((RequestHandler)this);
        RuleWsSupport.defineGenericRuleSearchParameters(action);
        RuleWsSupport.defineIsExternalParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchRequest searchWsRequest = SearchAction.toSearchWsRequest(request);
            SearchOptions context = SearchAction.buildSearchOptions(searchWsRequest);
            RuleQuery query = this.ruleQueryFactory.createRuleSearchQuery(dbSession, request);
            SearchResult searchResult = this.doSearch(dbSession, query, context);
            Rules.SearchResponse responseBuilder = this.buildResponse(dbSession, searchWsRequest, context, searchResult, query);
            WsUtils.writeProtobuf((Message)responseBuilder, request, response);
        }
    }

    private Rules.SearchResponse buildResponse(DbSession dbSession, SearchRequest request, SearchOptions context, SearchResult result, RuleQuery query) {
        Rules.SearchResponse.Builder responseBuilder = Rules.SearchResponse.newBuilder();
        SearchAction.writeStatistics(responseBuilder, result, context);
        this.doContextResponse(dbSession, request, result, responseBuilder, query);
        if (!context.getFacets().isEmpty()) {
            SearchAction.writeFacets(responseBuilder, request, context, result);
        }
        return responseBuilder.build();
    }

    private static void writeStatistics(Rules.SearchResponse.Builder response, SearchResult searchResult, SearchOptions context) {
        response.setTotal(searchResult.total.longValue());
        response.setP(context.getPage());
        response.setPs((long)context.getLimit());
    }

    private void writeRules(DbSession dbSession, Rules.SearchResponse.Builder response, SearchResult result, SearchOptions context) {
        Map<String, UserDto> usersByUuid = this.ruleWsSupport.getUsersByUuid(dbSession, result.rules);
        result.rules.forEach(rule -> response.addRules(this.mapper.toWsRule(rule.getDefinition(), result, context.getFields(), rule.getMetadata(), usersByUuid)));
    }

    private static SearchOptions buildSearchOptions(SearchRequest request) {
        SearchOptions context = SearchAction.loadCommonContext(request);
        SearchOptions searchOptions = new SearchOptions().setLimit(context.getLimit()).setOffset(context.getOffset());
        if (context.getFacets().contains("true")) {
            searchOptions.addFacets(DEFAULT_FACETS);
        } else {
            searchOptions.addFacets(context.getFacets());
        }
        return searchOptions;
    }

    private static SearchOptions loadCommonContext(SearchRequest request) {
        int pageSize = Integer.parseInt(request.getPs());
        SearchOptions context = new SearchOptions().addFields((Collection)request.getF());
        if (request.getFacets() != null) {
            context.addFacets((Collection)request.getFacets());
        }
        if (pageSize < 1) {
            context.setPage(Integer.parseInt(request.getP()), 0).setLimit(500);
        } else {
            context.setPage(Integer.parseInt(request.getP()), pageSize);
        }
        return context;
    }

    private SearchResult doSearch(DbSession dbSession, RuleQuery query, SearchOptions context) {
        SearchIdResult result = this.ruleIndex.search(query, context);
        List ruleIds = result.getIds();
        ImmutableMap rulesByRuleKey = Maps.uniqueIndex((Iterable)this.dbClient.ruleDao().selectByIds(dbSession, query.getOrganization().getUuid(), ruleIds), RuleDto::getId);
        ArrayList<RuleDto> rules = new ArrayList<RuleDto>();
        for (Integer ruleId : ruleIds) {
            RuleDto rule = (RuleDto)rulesByRuleKey.get(ruleId);
            if (rule == null) continue;
            rules.add(rule);
        }
        List templateRuleIds = (List)rules.stream().map(RuleDto::getTemplateId).filter(Objects::nonNull).collect(MoreCollectors.toList());
        List templateRules = this.dbClient.ruleDao().selectDefinitionByIds(dbSession, (Collection)templateRuleIds);
        List ruleParamDtos = this.dbClient.ruleDao().selectRuleParamsByRuleIds(dbSession, (Collection)ruleIds);
        return new SearchResult().setRules(rules).setRuleParameters(ruleParamDtos).setTemplateRules(templateRules).setFacets(result.getFacets()).setTotal(result.getTotal());
    }

    private void doContextResponse(DbSession dbSession, SearchRequest request, SearchResult result, Rules.SearchResponse.Builder response, RuleQuery query) {
        SearchOptions contextForResponse = SearchAction.loadCommonContext(request);
        this.writeRules(dbSession, response, result, contextForResponse);
        if (contextForResponse.getFields().contains("actives") && this.ruleWsSupport.areActiveRulesVisible(query.getOrganization())) {
            this.activeRuleCompleter.completeSearch(dbSession, query, result.rules, response);
        }
    }

    private static void writeFacets(Rules.SearchResponse.Builder response, SearchRequest request, SearchOptions context, SearchResult results) {
        SearchAction.addMandatoryFacetValues(results, "languages", request.getLanguages());
        SearchAction.addMandatoryFacetValues(results, "repositories", request.getRepositories());
        SearchAction.addMandatoryFacetValues(results, "statuses", RuleIndex.ALL_STATUSES_EXCEPT_REMOVED);
        SearchAction.addMandatoryFacetValues(results, "severities", Severity.ALL);
        SearchAction.addMandatoryFacetValues(results, "active_severities", Severity.ALL);
        SearchAction.addMandatoryFacetValues(results, "tags", request.getTags());
        SearchAction.addMandatoryFacetValues(results, "types", RuleType.names());
        SearchAction.addMandatoryFacetValues(results, "cwe", request.getCwe());
        SearchAction.addMandatoryFacetValues(results, "owaspTop10", request.getOwaspTop10());
        SearchAction.addMandatoryFacetValues(results, "sansTop25", request.getSansTop25());
        SearchAction.addMandatoryFacetValues(results, "sonarsourceSecurity", request.getSonarsourceSecurity());
        Common.Facet.Builder facet = Common.Facet.newBuilder();
        Common.FacetValue.Builder value = Common.FacetValue.newBuilder();
        HashMap<String, List<String>> facetValuesByFacetKey = new HashMap<String, List<String>>();
        facetValuesByFacetKey.put("languages", request.getLanguages());
        facetValuesByFacetKey.put("repositories", request.getRepositories());
        facetValuesByFacetKey.put("statuses", request.getStatuses());
        facetValuesByFacetKey.put("severities", request.getSeverities());
        facetValuesByFacetKey.put("active_severities", request.getActiveSeverities());
        facetValuesByFacetKey.put("tags", request.getTags());
        facetValuesByFacetKey.put("types", request.getTypes());
        facetValuesByFacetKey.put("cwe", request.getCwe());
        facetValuesByFacetKey.put("owaspTop10", request.getOwaspTop10());
        facetValuesByFacetKey.put("sansTop25", request.getSansTop25());
        facetValuesByFacetKey.put("sonarsourceSecurity", request.getSonarsourceSecurity());
        for (String facetName : context.getFacets()) {
            facet.clear().setProperty(facetName);
            LinkedHashMap facets = results.facets.get(facetName);
            if (facets != null) {
                HashSet<String> itemsFromFacets = new HashSet<String>();
                for (Map.Entry facetValue : facets.entrySet()) {
                    itemsFromFacets.add((String)facetValue.getKey());
                    facet.addValues(value.clear().setVal((String)facetValue.getKey()).setCount(((Long)facetValue.getValue()).longValue()));
                }
                SearchAction.addZeroFacetsForSelectedItems(facet, (List)facetValuesByFacetKey.get(facetName), itemsFromFacets);
            }
            response.getFacetsBuilder().addFacets(facet);
        }
    }

    private static void addZeroFacetsForSelectedItems(Common.Facet.Builder facet, @Nullable List<String> requestParams, Set<String> itemsFromFacets) {
        if (requestParams != null) {
            Common.FacetValue.Builder value = Common.FacetValue.newBuilder();
            for (String param : requestParams) {
                if (itemsFromFacets.contains(param)) continue;
                facet.addValues(value.clear().setVal(param).setCount(0L));
            }
        }
    }

    private static void addMandatoryFacetValues(SearchResult results, String facetName, @Nullable Collection<String> mandatoryValues) {
        LinkedHashMap facetValues = results.facets.get(facetName);
        if (facetValues != null) {
            Collection<Object> valuesToAdd = mandatoryValues == null ? Lists.newArrayList() : mandatoryValues;
            for (String string : valuesToAdd) {
                if (facetValues.containsKey(string)) continue;
                facetValues.put(string, 0L);
            }
        }
    }

    private static SearchRequest toSearchWsRequest(Request request) {
        request.mandatoryParamAsBoolean("asc");
        return new SearchRequest().setActiveSeverities(request.paramAsStrings("active_severities")).setF(request.paramAsStrings("f")).setFacets(request.paramAsStrings("facets")).setLanguages(request.paramAsStrings("languages")).setP("" + request.mandatoryParamAsInt("p")).setPs("" + request.mandatoryParamAsInt("ps")).setRepositories(request.paramAsStrings("repositories")).setSeverities(request.paramAsStrings("severities")).setStatuses(request.paramAsStrings("statuses")).setTags(request.paramAsStrings("tags")).setTypes(request.paramAsStrings("types")).setCwe(request.paramAsStrings("cwe")).setOwaspTop10(request.paramAsStrings("owaspTop10")).setSansTop25(request.paramAsStrings("sansTop25")).setSonarsourceSecurity(request.paramAsStrings("sonarsourceSecurity"));
    }

    private static class SearchRequest {
        private List<String> activeSeverities;
        private List<String> f;
        private List<String> facets;
        private List<String> languages;
        private String p;
        private String ps;
        private List<String> repositories;
        private List<String> severities;
        private List<String> statuses;
        private List<String> tags;
        private List<String> types;
        private List<String> cwe;
        private List<String> owaspTop10;
        private List<String> sansTop25;
        private List<String> sonarsourceSecurity;

        private SearchRequest() {
        }

        private SearchRequest setActiveSeverities(List<String> activeSeverities) {
            this.activeSeverities = activeSeverities;
            return this;
        }

        private List<String> getActiveSeverities() {
            return this.activeSeverities;
        }

        private SearchRequest setF(List<String> f) {
            this.f = f;
            return this;
        }

        private List<String> getF() {
            return this.f;
        }

        private SearchRequest setFacets(List<String> facets) {
            this.facets = facets;
            return this;
        }

        private List<String> getFacets() {
            return this.facets;
        }

        private SearchRequest setLanguages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        private List<String> getLanguages() {
            return this.languages;
        }

        private SearchRequest setP(String p) {
            this.p = p;
            return this;
        }

        private String getP() {
            return this.p;
        }

        private SearchRequest setPs(String ps) {
            this.ps = ps;
            return this;
        }

        private String getPs() {
            return this.ps;
        }

        private SearchRequest setRepositories(List<String> repositories) {
            this.repositories = repositories;
            return this;
        }

        private List<String> getRepositories() {
            return this.repositories;
        }

        private SearchRequest setSeverities(List<String> severities) {
            this.severities = severities;
            return this;
        }

        private List<String> getSeverities() {
            return this.severities;
        }

        private SearchRequest setStatuses(List<String> statuses) {
            this.statuses = statuses;
            return this;
        }

        private List<String> getStatuses() {
            return this.statuses;
        }

        private SearchRequest setTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        private List<String> getTags() {
            return this.tags;
        }

        private SearchRequest setTypes(@Nullable List<String> types) {
            this.types = types;
            return this;
        }

        private List<String> getTypes() {
            return this.types;
        }

        public List<String> getCwe() {
            return this.cwe;
        }

        public SearchRequest setCwe(@Nullable List<String> cwe) {
            this.cwe = cwe;
            return this;
        }

        public List<String> getOwaspTop10() {
            return this.owaspTop10;
        }

        public SearchRequest setOwaspTop10(@Nullable List<String> owaspTop10) {
            this.owaspTop10 = owaspTop10;
            return this;
        }

        public List<String> getSansTop25() {
            return this.sansTop25;
        }

        public SearchRequest setSansTop25(@Nullable List<String> sansTop25) {
            this.sansTop25 = sansTop25;
            return this;
        }

        public List<String> getSonarsourceSecurity() {
            return this.sonarsourceSecurity;
        }

        public SearchRequest setSonarsourceSecurity(@Nullable List<String> sonarsourceSecurity) {
            this.sonarsourceSecurity = sonarsourceSecurity;
            return this;
        }
    }

    static class SearchResult {
        private List<RuleDto> rules = new ArrayList<RuleDto>();
        private final ListMultimap<Integer, RuleParamDto> ruleParamsByRuleId = ArrayListMultimap.create();
        private final Map<Integer, RuleDefinitionDto> templateRulesByRuleId = new HashMap<Integer, RuleDefinitionDto>();
        private Long total;
        private Facets facets;

        public List<RuleDto> getRules() {
            return this.rules;
        }

        public SearchResult setRules(List<RuleDto> rules) {
            this.rules = rules;
            return this;
        }

        public ListMultimap<Integer, RuleParamDto> getRuleParamsByRuleId() {
            return this.ruleParamsByRuleId;
        }

        public SearchResult setRuleParameters(List<RuleParamDto> ruleParams) {
            this.ruleParamsByRuleId.clear();
            for (RuleParamDto ruleParam : ruleParams) {
                this.ruleParamsByRuleId.put((Object)ruleParam.getRuleId(), (Object)ruleParam);
            }
            return this;
        }

        public Map<Integer, RuleDefinitionDto> getTemplateRulesByRuleId() {
            return this.templateRulesByRuleId;
        }

        public SearchResult setTemplateRules(List<RuleDefinitionDto> templateRules) {
            this.templateRulesByRuleId.clear();
            for (RuleDefinitionDto templateRule : templateRules) {
                this.templateRulesByRuleId.put(templateRule.getId(), templateRule);
            }
            return this;
        }

        @CheckForNull
        public Long getTotal() {
            return this.total;
        }

        public SearchResult setTotal(Long total) {
            this.total = total;
            return this;
        }

        @CheckForNull
        public Facets getFacets() {
            return this.facets;
        }

        public SearchResult setFacets(Facets facets) {
            this.facets = facets;
            return this;
        }
    }
}

