/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ServerSide;
import org.sonar.core.platform.PlatformEditionProvider;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.SumNclocDbQuery;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.measure.index.ProjectMeasuresIndex;
import org.sonar.server.measure.index.ProjectMeasuresStatistics;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.property.InternalProperties;
import org.sonar.server.telemetry.LicenseReader;
import org.sonar.server.telemetry.TelemetryData;
import org.sonar.server.user.index.UserIndex;
import org.sonar.server.user.index.UserQuery;

@ServerSide
public class TelemetryDataLoader {
    private final Server server;
    private final DbClient dbClient;
    private final PluginRepository pluginRepository;
    private final UserIndex userIndex;
    private final ProjectMeasuresIndex projectMeasuresIndex;
    private final PlatformEditionProvider editionProvider;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final InternalProperties internalProperties;
    @CheckForNull
    private final LicenseReader licenseReader;

    public TelemetryDataLoader(Server server, DbClient dbClient, PluginRepository pluginRepository, UserIndex userIndex, ProjectMeasuresIndex projectMeasuresIndex, PlatformEditionProvider editionProvider, DefaultOrganizationProvider defaultOrganizationProvider, InternalProperties internalProperties) {
        this(server, dbClient, pluginRepository, userIndex, projectMeasuresIndex, editionProvider, defaultOrganizationProvider, internalProperties, null);
    }

    public TelemetryDataLoader(Server server, DbClient dbClient, PluginRepository pluginRepository, UserIndex userIndex, ProjectMeasuresIndex projectMeasuresIndex, PlatformEditionProvider editionProvider, DefaultOrganizationProvider defaultOrganizationProvider, InternalProperties internalProperties, @Nullable LicenseReader licenseReader) {
        this.server = server;
        this.dbClient = dbClient;
        this.pluginRepository = pluginRepository;
        this.userIndex = userIndex;
        this.projectMeasuresIndex = projectMeasuresIndex;
        this.editionProvider = editionProvider;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.licenseReader = licenseReader;
        this.internalProperties = internalProperties;
    }

    private static TelemetryData.Database loadDatabaseMetadata(DbSession dbSession) {
        try {
            DatabaseMetaData metadata = dbSession.getConnection().getMetaData();
            return new TelemetryData.Database(metadata.getDatabaseProductName(), metadata.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to get DB metadata", e);
        }
    }

    public TelemetryData load() {
        TelemetryData.Builder data = TelemetryData.builder();
        data.setServerId(this.server.getId());
        data.setVersion(this.server.getVersion());
        data.setEdition(this.editionProvider.get());
        Optional.ofNullable(this.licenseReader).flatMap(reader -> this.licenseReader.read()).ifPresent(license -> data.setLicenseType(license.getType()));
        Function<PluginInfo, String> getVersion = plugin -> plugin.getVersion() == null ? "undefined" : plugin.getVersion().getName();
        Map plugins = (Map)this.pluginRepository.getPluginInfos().stream().collect(MoreCollectors.uniqueIndex(PluginInfo::getKey, getVersion));
        data.setPlugins(plugins);
        long userCount = this.userIndex.search(UserQuery.builder().build(), new SearchOptions().setLimit(1)).getTotal();
        data.setUserCount(userCount);
        ProjectMeasuresStatistics projectMeasuresStatistics = this.projectMeasuresIndex.searchTelemetryStatistics();
        data.setProjectMeasuresStatistics(projectMeasuresStatistics);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            data.setDatabase(TelemetryDataLoader.loadDatabaseMetadata(dbSession));
            data.setUsingBranches(this.dbClient.branchDao().hasNonMainBranches(dbSession));
            SumNclocDbQuery query = SumNclocDbQuery.builder().setOnlyPrivateProjects(Boolean.valueOf(false)).setOrganizationUuid(this.defaultOrganizationProvider.get().getUuid()).build();
            data.setNcloc(this.dbClient.liveMeasureDao().sumNclocOfBiggestLongLivingBranch(dbSession, query));
        }
        Optional installationDateProperty = this.internalProperties.read("installation.date");
        if (installationDateProperty.isPresent()) {
            data.setInstallationDate(Long.valueOf((String)installationDateProperty.get()));
        }
        Optional installationVersionProperty = this.internalProperties.read("installation.version");
        data.setInstallationVersion(installationVersionProperty.orElse(null));
        return data.build();
    }

    String loadServerId() {
        return this.server.getId();
    }
}

