/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui.ws;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.web.page.Page;
import org.sonar.core.platform.PlatformEditionProvider;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.process.ProcessProperties;
import org.sonar.server.branch.BranchFeatureProxy;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.platform.WebServer;
import org.sonar.server.ui.PageRepository;
import org.sonar.server.ui.VersionFormatter;
import org.sonar.server.ui.WebAnalyticsLoader;
import org.sonar.server.ui.ws.NavigationWsAction;
import org.sonar.server.user.UserSession;

public class GlobalAction
implements NavigationWsAction,
Startable {
    private static final Set<String> DYNAMIC_SETTING_KEYS = ImmutableSet.of((Object)"sonar.lf.logoUrl", (Object)"sonar.lf.logoWidthPx", (Object)"sonar.lf.enableGravatar", (Object)"sonar.lf.gravatarServerUrl", (Object)"sonar.technicalDebt.ratingGrid");
    private final Map<String, String> systemSettingValuesByKey;
    private final PageRepository pageRepository;
    private final Configuration config;
    private final ResourceTypes resourceTypes;
    private final Server server;
    private final WebServer webServer;
    private final DbClient dbClient;
    private final OrganizationFlags organizationFlags;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final BranchFeatureProxy branchFeature;
    private final UserSession userSession;
    private final PlatformEditionProvider editionProvider;
    private final WebAnalyticsLoader webAnalyticsLoader;

    public GlobalAction(PageRepository pageRepository, Configuration config, ResourceTypes resourceTypes, Server server, WebServer webServer, DbClient dbClient, OrganizationFlags organizationFlags, DefaultOrganizationProvider defaultOrganizationProvider, BranchFeatureProxy branchFeature, UserSession userSession, PlatformEditionProvider editionProvider, WebAnalyticsLoader webAnalyticsLoader) {
        this.pageRepository = pageRepository;
        this.config = config;
        this.resourceTypes = resourceTypes;
        this.server = server;
        this.webServer = webServer;
        this.dbClient = dbClient;
        this.organizationFlags = organizationFlags;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.branchFeature = branchFeature;
        this.userSession = userSession;
        this.editionProvider = editionProvider;
        this.webAnalyticsLoader = webAnalyticsLoader;
        this.systemSettingValuesByKey = new HashMap<String, String>();
    }

    public void start() {
        this.systemSettingValuesByKey.put(ProcessProperties.Property.SONAR_UPDATECENTER_ACTIVATE.getKey(), this.config.get(ProcessProperties.Property.SONAR_UPDATECENTER_ACTIVATE.getKey()).orElse(null));
        boolean isOnSonarCloud = this.config.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
        if (isOnSonarCloud) {
            this.systemSettingValuesByKey.put(ProcessProperties.Property.SONAR_PRISMIC_ACCESS_TOKEN.getKey(), this.config.get(ProcessProperties.Property.SONAR_PRISMIC_ACCESS_TOKEN.getKey()).orElse(null));
            this.systemSettingValuesByKey.put(ProcessProperties.Property.SONAR_ANALYTICS_GTM_TRACKING_ID.getKey(), this.config.get(ProcessProperties.Property.SONAR_ANALYTICS_GTM_TRACKING_ID.getKey()).orElse(null));
            this.systemSettingValuesByKey.put(ProcessProperties.Property.SONARCLOUD_HOMEPAGE_URL.getKey(), this.config.get(ProcessProperties.Property.SONARCLOUD_HOMEPAGE_URL.getKey()).orElse(null));
        }
    }

    public void stop() {
    }

    public void define(WebService.NewController context) {
        context.createAction("global").setDescription("Get information concerning global navigation for the current user.").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("global-example.json")).setSince("5.2");
    }

    public void handle(Request request, Response response) throws Exception {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject();
            this.writeActions(json);
            this.writePages(json);
            this.writeSettings(json);
            this.writeDeprecatedLogoProperties(json);
            this.writeQualifiers(json);
            this.writeVersion(json);
            this.writeDatabaseProduction(json);
            this.writeOrganizationSupport(json);
            this.writeBranchSupport(json);
            this.editionProvider.get().ifPresent(e -> json.prop("edition", e.name().toLowerCase(Locale.ENGLISH)));
            json.prop("standalone", this.webServer.isStandalone());
            this.writeWebAnalytics(json);
            json.endObject();
        }
    }

    private void writeActions(JsonWriter json) {
        json.prop("canAdmin", this.userSession.isSystemAdministrator());
    }

    private void writePages(JsonWriter json) {
        json.name("globalPages").beginArray();
        for (Page page : this.pageRepository.getGlobalPages(false)) {
            json.beginObject().prop("key", page.getKey()).prop("name", page.getName()).endObject();
        }
        json.endArray();
    }

    private void writeSettings(JsonWriter json) {
        json.name("settings").beginObject();
        DYNAMIC_SETTING_KEYS.forEach(key -> json.prop(key, (String)this.config.get(key).orElse(null)));
        this.systemSettingValuesByKey.forEach((arg_0, arg_1) -> ((JsonWriter)json).prop(arg_0, arg_1));
        json.endObject();
    }

    private void writeDeprecatedLogoProperties(JsonWriter json) {
        json.prop("logoUrl", (String)this.config.get("sonar.lf.logoUrl").orElse(null));
        json.prop("logoWidth", (String)this.config.get("sonar.lf.logoWidthPx").orElse(null));
    }

    private void writeQualifiers(JsonWriter json) {
        json.name("qualifiers").beginArray();
        for (ResourceType rootType : this.resourceTypes.getRoots()) {
            json.value(rootType.getQualifier());
        }
        json.endArray();
    }

    private void writeVersion(JsonWriter json) {
        String displayVersion = VersionFormatter.format(this.server.getVersion());
        json.prop("version", displayVersion);
    }

    private void writeDatabaseProduction(JsonWriter json) {
        json.prop("productionDatabase", !this.dbClient.getDatabase().getDialect().getId().equals("h2"));
    }

    private void writeOrganizationSupport(JsonWriter json) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            json.prop("organizationsEnabled", this.organizationFlags.isEnabled(dbSession));
            json.prop("defaultOrganization", this.defaultOrganizationProvider.get().getKey());
        }
    }

    private void writeBranchSupport(JsonWriter json) {
        json.prop("branchesEnabled", this.branchFeature.isEnabled());
    }

    private void writeWebAnalytics(JsonWriter json) {
        this.webAnalyticsLoader.getUrlPathToJs().ifPresent(p -> json.prop("webAnalyticsJsPath", p));
    }
}

