/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.usertoken.ws.UserTokenSupport;
import org.sonar.server.usertoken.ws.UserTokensWsAction;

public class RevokeAction
implements UserTokensWsAction {
    private final DbClient dbClient;
    private final UserTokenSupport userTokenSupport;

    public RevokeAction(DbClient dbClient, UserTokenSupport userTokenSupport) {
        this.dbClient = dbClient;
        this.userTokenSupport = userTokenSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("revoke").setDescription("Revoke a user access token. <br/>It requires administration permissions to specify a 'login' and revoke a token for another user. Otherwise, the token for the current user is revoked.").setSince("5.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login").setExampleValue((Object)"g.hopper");
        action.createParam("name").setRequired(true).setDescription("Token name").setExampleValue((Object)"Project scan on Travis");
    }

    public void handle(Request request, Response response) throws Exception {
        String name = request.mandatoryParam("name");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.userTokenSupport.getUser(dbSession, request);
            this.dbClient.userTokenDao().deleteByUserAndName(dbSession, user, name);
            dbSession.commit();
        }
        response.noContent();
    }
}

