/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.Response;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.ProtobufJsonFormat;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.exceptions.NotFoundException;

public class WsUtils {
    private static final Set<String> MODULE_OR_DIR_QUALIFIERS = ImmutableSet.of((Object)"BRC", (Object)"DIR");

    private WsUtils() {
    }

    public static void writeProtobuf(Message msg, Request request, Response response) {
        block12: {
            OutputStream output = response.stream().output();
            try {
                if (request.getMediaType().equals("application/x-protobuf")) {
                    response.stream().setMediaType("application/x-protobuf");
                    msg.writeTo(output);
                    break block12;
                }
                response.stream().setMediaType("application/json");
                try (JsonWriter writer = JsonWriter.of((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8));){
                    ProtobufJsonFormat.write((Message)msg, (JsonWriter)writer);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while writing protobuf message", e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
    }

    public static void checkRequest(boolean expression, String message, Object ... messageArguments) {
        if (!expression) {
            throw BadRequestException.create(String.format(message, messageArguments));
        }
    }

    public static void checkRequest(boolean expression, List<String> messages) {
        if (!expression) {
            throw BadRequestException.create(messages);
        }
    }

    public static <T> T checkFound(@Nullable T value, String message, Object ... messageArguments) {
        if (value == null) {
            throw new NotFoundException(String.format(message, messageArguments));
        }
        return value;
    }

    public static <T> T checkFoundWithOptional(com.google.common.base.Optional<T> value, String message, Object ... messageArguments) {
        if (!value.isPresent()) {
            throw new NotFoundException(String.format(message, messageArguments));
        }
        return (T)value.get();
    }

    public static <T> T checkFoundWithOptional(Optional<T> value, String message, Object ... messageArguments) {
        if (!value.isPresent()) {
            throw new NotFoundException(String.format(message, messageArguments));
        }
        return value.get();
    }

    public static <T> T checkStateWithOptional(Optional<T> value, String message, Object ... messageArguments) {
        if (!value.isPresent()) {
            throw new IllegalStateException(String.format(message, messageArguments));
        }
        return value.get();
    }

    public static void checkComponentNotAModuleAndNotADirectory(ComponentDto component) {
        WsUtils.checkRequest(!MODULE_OR_DIR_QUALIFIERS.contains(component.qualifier()), "Operation not supported for module or directory components", new Object[0]);
    }
}

