/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.error.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public class DefaultAnalysisError
extends DefaultStorable
implements NewAnalysisError,
AnalysisError {
    private InputFile inputFile;
    private String message;
    private TextPointer location;

    public DefaultAnalysisError() {
        super(null);
    }

    public DefaultAnalysisError(SensorStorage storage) {
        super(storage);
    }

    @Override
    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public TextPointer location() {
        return this.location;
    }

    @Override
    public NewAnalysisError onFile(InputFile inputFile) {
        Preconditions.checkArgument((inputFile != null ? 1 : 0) != 0, (Object)"Cannot use a inputFile that is null");
        Preconditions.checkState((this.inputFile == null ? 1 : 0) != 0, (Object)"onFile() already called");
        this.inputFile = inputFile;
        return this;
    }

    @Override
    public NewAnalysisError message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public NewAnalysisError at(TextPointer location) {
        Preconditions.checkState((this.location == null ? 1 : 0) != 0, (Object)"at() already called");
        this.location = location;
        return this;
    }

    @Override
    protected void doSave() {
        Objects.requireNonNull(this.inputFile, "inputFile is mandatory on AnalysisError");
        this.storage.store(this);
    }
}

