/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.user;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.security.DefaultGroups;

public class UserGroupValidation {
    public static final int GROUP_NAME_MAX_LENGTH = 255;

    private UserGroupValidation() {
    }

    public static void validateGroupName(String groupName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)groupName) && groupName.trim().length() > 0 ? 1 : 0) != 0, (Object)"Group name cannot be empty");
        Preconditions.checkArgument((groupName.length() <= 255 ? 1 : 0) != 0, (String)"Group name cannot be longer than %s characters", (Object[])new Object[]{255});
        Preconditions.checkArgument((!DefaultGroups.isAnyone(groupName) ? 1 : 0) != 0, (Object)"Anyone group cannot be used");
    }
}

