/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.measurecomputer;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.ce.measure.Settings;
import org.sonar.ce.task.projectanalysis.api.measurecomputer.ComponentImpl;
import org.sonar.ce.task.projectanalysis.api.measurecomputer.MeasureImpl;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesRepository;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.core.issue.DefaultIssue;

public class MeasureComputerContextImpl
implements MeasureComputer.MeasureComputerContext {
    private final ConfigurationRepository config;
    private final MeasureRepository measureRepository;
    private final MetricRepository metricRepository;
    private final Component internalComponent;
    private final org.sonar.api.ce.measure.Component component;
    private final List<DefaultIssue> componentIssues;
    private MeasureComputer.MeasureComputerDefinition definition;
    private Set<String> allowedMetrics;

    public MeasureComputerContextImpl(Component component, ConfigurationRepository config, MeasureRepository measureRepository, MetricRepository metricRepository, ComponentIssuesRepository componentIssuesRepository) {
        this.config = config;
        this.internalComponent = component;
        this.measureRepository = measureRepository;
        this.metricRepository = metricRepository;
        this.component = MeasureComputerContextImpl.newComponent(component);
        this.componentIssues = componentIssuesRepository.getIssues(component);
    }

    public MeasureComputerContextImpl setDefinition(MeasureComputer.MeasureComputerDefinition definition) {
        this.definition = definition;
        this.allowedMetrics = MeasureComputerContextImpl.allowedMetric(definition);
        return this;
    }

    private static Set<String> allowedMetric(MeasureComputer.MeasureComputerDefinition definition) {
        HashSet<String> allowedMetrics = new HashSet<String>();
        allowedMetrics.addAll(definition.getInputMetrics());
        allowedMetrics.addAll(definition.getOutputMetrics());
        return allowedMetrics;
    }

    public org.sonar.api.ce.measure.Component getComponent() {
        return this.component;
    }

    public Settings getSettings() {
        return new Settings(){

            @CheckForNull
            public String getString(String key) {
                return MeasureComputerContextImpl.this.config.getConfiguration().get(key).orElse(null);
            }

            public String[] getStringArray(String key) {
                return MeasureComputerContextImpl.this.config.getConfiguration().getStringArray(key);
            }
        };
    }

    @CheckForNull
    public Measure getMeasure(String metric) {
        this.validateInputMetric(metric);
        Optional<org.sonar.ce.task.projectanalysis.measure.Measure> measure = this.measureRepository.getRawMeasure(this.internalComponent, this.metricRepository.getByKey(metric));
        if (measure.isPresent()) {
            return new MeasureImpl(measure.get());
        }
        return null;
    }

    public Iterable<Measure> getChildrenMeasures(String metric) {
        this.validateInputMetric(metric);
        return FluentIterable.from(this.internalComponent.getChildren()).transform((Function)new ComponentToMeasure(this.metricRepository.getByKey(metric))).transform((Function)ToMeasureAPI.INSTANCE).filter(Predicates.notNull());
    }

    public void addMeasure(String metricKey, int value) {
        Metric metric = this.metricRepository.getByKey(metricKey);
        this.validateAddMeasure(metric);
        this.measureRepository.add(this.internalComponent, metric, org.sonar.ce.task.projectanalysis.measure.Measure.newMeasureBuilder().create(value));
    }

    public void addMeasure(String metricKey, double value) {
        Metric metric = this.metricRepository.getByKey(metricKey);
        this.validateAddMeasure(metric);
        this.measureRepository.add(this.internalComponent, metric, org.sonar.ce.task.projectanalysis.measure.Measure.newMeasureBuilder().create(value, metric.getDecimalScale()));
    }

    public void addMeasure(String metricKey, long value) {
        Metric metric = this.metricRepository.getByKey(metricKey);
        this.validateAddMeasure(metric);
        this.measureRepository.add(this.internalComponent, metric, org.sonar.ce.task.projectanalysis.measure.Measure.newMeasureBuilder().create(value));
    }

    public void addMeasure(String metricKey, String value) {
        Metric metric = this.metricRepository.getByKey(metricKey);
        this.validateAddMeasure(metric);
        this.measureRepository.add(this.internalComponent, metric, org.sonar.ce.task.projectanalysis.measure.Measure.newMeasureBuilder().create(value));
    }

    public void addMeasure(String metricKey, boolean value) {
        Metric metric = this.metricRepository.getByKey(metricKey);
        this.validateAddMeasure(metric);
        this.measureRepository.add(this.internalComponent, metric, org.sonar.ce.task.projectanalysis.measure.Measure.newMeasureBuilder().create(value));
    }

    private void validateInputMetric(String metric) {
        Preconditions.checkArgument((boolean)this.allowedMetrics.contains(metric), (String)"Only metrics in %s can be used to load measures", (Object[])new Object[]{this.definition.getInputMetrics()});
    }

    private void validateAddMeasure(Metric metric) {
        Preconditions.checkArgument((boolean)this.definition.getOutputMetrics().contains(metric.getKey()), (String)"Only metrics in %s can be used to add measures. Metric '%s' is not allowed.", (Object[])new Object[]{this.definition.getOutputMetrics(), metric.getKey()});
        if (this.measureRepository.getRawMeasure(this.internalComponent, metric).isPresent()) {
            throw new UnsupportedOperationException(String.format("A measure on metric '%s' already exists on component '%s'", metric.getKey(), this.internalComponent.getDbKey()));
        }
    }

    public List<? extends Issue> getIssues() {
        return this.componentIssues;
    }

    private static org.sonar.api.ce.measure.Component newComponent(Component component) {
        return new ComponentImpl(component.getDbKey(), Component.Type.valueOf((String)component.getType().name()), component.getType() == Component.Type.FILE ? new ComponentImpl.FileAttributesImpl(component.getFileAttributes().getLanguageKey(), component.getFileAttributes().isUnitTest()) : null);
    }

    private static enum ToMeasureAPI implements Function<Optional<org.sonar.ce.task.projectanalysis.measure.Measure>, Measure>
    {
        INSTANCE;


        @Nullable
        public Measure apply(@Nonnull Optional<org.sonar.ce.task.projectanalysis.measure.Measure> input) {
            return input.isPresent() ? new MeasureImpl(input.get()) : null;
        }
    }

    private class ComponentToMeasure
    implements Function<Component, Optional<org.sonar.ce.task.projectanalysis.measure.Measure>> {
        private final Metric metric;

        public ComponentToMeasure(Metric metric) {
            this.metric = metric;
        }

        public Optional<org.sonar.ce.task.projectanalysis.measure.Measure> apply(@Nonnull Component input) {
            return MeasureComputerContextImpl.this.measureRepository.getRawMeasure(input, this.metric);
        }
    }
}

