/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.measurecomputer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.measure.MeasureComputer;

public class MeasureComputerDefinitionImpl
implements MeasureComputer.MeasureComputerDefinition {
    private final Set<String> inputMetricKeys;
    private final Set<String> outputMetrics;

    private MeasureComputerDefinitionImpl(BuilderImpl builder) {
        this.inputMetricKeys = ImmutableSet.copyOf((Object[])builder.inputMetricKeys);
        this.outputMetrics = ImmutableSet.copyOf((Object[])builder.outputMetrics);
    }

    public Set<String> getInputMetrics() {
        return this.inputMetricKeys;
    }

    public Set<String> getOutputMetrics() {
        return this.outputMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasureComputerDefinitionImpl that = (MeasureComputerDefinitionImpl)o;
        if (!this.inputMetricKeys.equals(that.inputMetricKeys)) {
            return false;
        }
        return this.outputMetrics.equals(that.outputMetrics);
    }

    public int hashCode() {
        int result = this.inputMetricKeys.hashCode();
        result = 31 * result + this.outputMetrics.hashCode();
        return result;
    }

    public String toString() {
        return "MeasureComputerDefinitionImpl{inputMetricKeys=" + this.inputMetricKeys + ", outputMetrics=" + this.outputMetrics + '}';
    }

    public static class BuilderImpl
    implements MeasureComputer.MeasureComputerDefinition.Builder {
        private String[] inputMetricKeys = new String[0];
        @CheckForNull
        private String[] outputMetrics;

        public MeasureComputer.MeasureComputerDefinition.Builder setInputMetrics(String ... inputMetrics) {
            this.inputMetricKeys = BuilderImpl.validateInputMetricKeys(inputMetrics);
            return this;
        }

        public MeasureComputer.MeasureComputerDefinition.Builder setOutputMetrics(String ... outputMetrics) {
            this.outputMetrics = BuilderImpl.validateOutputMetricKeys(outputMetrics);
            return this;
        }

        public MeasureComputer.MeasureComputerDefinition build() {
            BuilderImpl.validateInputMetricKeys(this.inputMetricKeys);
            BuilderImpl.validateOutputMetricKeys(this.outputMetrics);
            return new MeasureComputerDefinitionImpl(this);
        }

        private static String[] validateInputMetricKeys(@Nullable String[] inputMetrics) {
            Objects.requireNonNull(inputMetrics, "Input metrics cannot be null");
            BuilderImpl.checkNotNull(inputMetrics);
            return inputMetrics;
        }

        private static String[] validateOutputMetricKeys(@Nullable String[] outputMetrics) {
            Objects.requireNonNull(outputMetrics, "Output metrics cannot be null");
            Preconditions.checkArgument((outputMetrics.length > 0 ? 1 : 0) != 0, (Object)"At least one output metric must be defined");
            BuilderImpl.checkNotNull(outputMetrics);
            return outputMetrics;
        }

        private static void checkNotNull(String[] metrics) {
            for (String metric : metrics) {
                Objects.requireNonNull(metric, "Null metric is not allowed");
            }
        }
    }
}

