/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.posttask;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.posttask.ScannerContext;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;

@Immutable
class ScannerContextImpl
implements ScannerContext {
    private final Map<String, String> props;

    private ScannerContextImpl(Map<String, String> props) {
        this.props = props;
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    static ScannerContextImpl from(CloseableIterator<ScannerReport.ContextProperty> it) {
        try {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            while (it.hasNext()) {
                ScannerReport.ContextProperty prop = (ScannerReport.ContextProperty)it.next();
                mapBuilder.put((Object)prop.getKey(), (Object)prop.getValue());
            }
            ScannerContextImpl scannerContextImpl = new ScannerContextImpl((Map<String, String>)mapBuilder.build());
            return scannerContextImpl;
        }
        finally {
            it.close();
        }
    }
}

